(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra información relevante acerca de la conexión (Internet) de la Red de Área Amplia."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La única dirección física asignada al puerto (WAN) de Internet del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IP asignada al puerto (WAN) de Internet del router. Si la dirección IP se muestra como 0.0.0.0, indica que no hay acceso a Internet."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Este parámetro determina parte de la red y parte del host de una dirección IP."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP usada para conectar el router a la red."
                }, {
                    type: "name",
                    title: "DNS Primario / DNS Secundario",
                    content: "El DNS (Domain Name System - Sistema de Nombres de Dominio) traduce los nombres de host y los dominios de Internet a las direcciones IP. La información de estos servidores DNS es asignada por el Proveedor de Servicios de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "El tipo de conexión actual del puerto (WAN) de Internet."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección física única asignada al puerto (WAN) de Internet del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IP asignada al puerto (WAN) de Internet del router."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP usada para conectar el router a la red."
                }, {
                    type: "name",
                    title: "DNS Primario / DNS Secundario",
                    content: "El DNS (Domain Name System - Sistema de Nombres de Dominio) traduce los nombres de host y los dominios de Internet a las direcciones IP. La información de estos servidores DNS es asignada por el Proveedor de Servicios de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "El tipo de conexión actual del puerto (WAN) de Internet."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Red Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dar clic en el ícono de Red Powerline para mostrar la lista de todos los dispositivos powerline en la red actual de powerline."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dar clic en el ícono de Powerline para mostrar la información detallada del extensor powerline local."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "El identificador único que es asignado al powerline"
                }, {
                    type: "name",
                    title: "Clave de Powerline",
                    content: "La clave única de este dispositivo powerline que es usada cuando está siendo agregada a una red powerline. Esta clave también está impresa en la etiqueta del producto."
                }, {
                    type: "name",
                    title: "Nombre de la Red",
                    content: "El nombre de la red en la que se encuentra el extensor powerline. El nombre predeterminado es HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "Red inalámbrica <span class=\"anti_5g\">/5GHz</span> de 2.4GHz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información de estado y básica de la Red Inalámbrica."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "El estado actual (Encendido o Apagado) de su Red Inalámbrica."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Identificador de Conjunto de Servicios, también conocido como red inalámbrica."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "El canal inalámbrico actual."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "La dirección MAC del inalámbrico del extensor powerline"
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información acerca de los puertos Ethernet (LAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La única dirección física asignada al puerto Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IPv4 asignada al puerto Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Este parámetro determina parte de la red y parte del host de una dirección IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Muestra si el servidor DHCP integrado del router está activo para los dispositivos en los puertos LAN o no. "
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La única dirección física asignada al puerto (LAN) de Ethernet del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IPv6 asignada al puerto (LAN) de Internet del router. "
                }, {
                    type: "name",
                    title: "Dirección de Enlace Local",
                    content: "La dirección de enlace de IPv6 para la interfaz de la LAN."
                }, {
                    type: "name",
                    title: "Tipo Asignado",
                    content: "El tipo de dirección IPv6 para la Interfaz de la LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "Red para invitados <span class=\"anti_5g\">/5GHz</span> de 2.4GHz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información acerca de la red inalámbrica para invitados."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "El estado actual (Encendido o Apagado) de la Red para Invitados."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "El nombre de la red inalámbrica (SSID) de su Red para Invitados."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Dispositivos USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información de los dispositivos de almacenamiento USB actuales y/o impresoras conectadas al router por medio de los puertos USB."
                }, {
                    type: "name",
                    title: "Impresora",
                    content: "El nombre de la impresora conectada."
                }, {
                    type: "name",
                    title: "Total",
                    content: "La capacidad de almacenamiento total del dispositivo de almacenamiento USB conectado."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "La capacidad de almacenamiento disponible del dispositivo de almacenamiento USB conectado."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Rendimiento",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra el rendimiento actual del router."
                }, {
                    type: "name",
                    title: "Carga de CPU",
                    content: "El uso del CPU actual."
                }, {
                    type: "name",
                    title: "Uso de Memoria",
                    content: "El uso de memoria actual."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Clientes conectados por cable",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información de todos los dispositivos conectados por cable que están conectados actualmente a la red."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Clientes inalámbricos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dar clic en el ícono de Clientes Inalámbricos para mostrar la información de todos los dispositivos inalámbricos que están conectados actualmente a la red inalámbrica integrada por el extensor powerline."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: " La dirección MAC del cliente inalámbrico. "
                }, {
                    type: "name",
                    title: "Banda Inalámbrica",
                    content: "La banda inalámbrica <span class=\"anti_5g\">(2.4GHz o 5GHz) </span> a la cual está conectado el cliente."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Sincronizar Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indica si la función de Sincronizar Wi-Fi está habilitada o no."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Estático"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si cuenta con una Dirección IP específica (fija), Máscara de Subred, Puerta de Enlace, y parámetros de DNS por parte del ISP."
                }, {
                    type: "name",
                    title: "Dirección IP / Máscara de Subred / Puerta de Enlace Predeterminada / DNS Primario / DNS Secundario",
                    content: "Ingresar la información proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico y predeterminado para la mayoría de las redes Ethernet es 1500 Bytes. NO se recomienda cambiar el tamaño del MTU predeterminado a menos que se requiera por el ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Dinámico"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si cuenta con una conexión del servidor DHCP por parte de su ISP (Proveedor de Servicios de Internet)."
                }, {
                    type: "name",
                    title: "Dirección IP/ Máscara de Subred / Puerta de Enlace Predeterminada / DNS Primario / DNS Secundario",
                    content: "Estos parámetros son asignados automáticamente por el servidor DHCP de su ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Dar clic en este botón para obtener los nuevos parámetros de IP del servidor DHCP."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Dar clic en este botón para liberar todas las direcciones IP asignadas por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Usar las siguientes Direcciones DNS",
                    content: "Si el ISP ofrece una o dos direcciones DNS, seleccione esta casilla de verificación e ingrese las direcciones del DNS Primario y DNS Secundario en los campos de entrada correspondientes; de lo contrario, las direcciones DNS serán asignadas de manera dinámica por el ISP."
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico y predeterminado para la mayoría de las redes Ethernet es 1500 Bytes. No se recomienda cambiar el tamaño del MTU predeterminado a menos que se requiera por el ISP."
                }, {
                    type: "name",
                    title: "Nombre del Host",
                    content: "Ingresar un valor en este campo para especificar el nombre del host del router."
                }, {
                    type: "name",
                    title: "Obtener el IP usando el DHCP de Unidifusión",
                    content: "Seleccionar esta casilla de verificación si su servidor DHCP del ISP no soporta aplicaciones de transmisión y no puede obtener la dirección IP de manera dinámica."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si encuentra errores de \"Dirección no encontrada\" errores después de introducir las direcciones DNS, es probable que los servidores DNS están configurados incorrectamente, póngase en contacto con el ISP para obtener asistencia."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si usa el servicio de DSL (Digital Subscriber Line - Línea de Suscripción Digital) y cuenta con un nombre de usuario y contraseña proporcionados por el ISP."
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Dirección IP de Internet / DNS Primario / DNS Secundario",
                    content: "Estos parámetros son asignados de manera automática por el servidor DHCP en su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (Ninguna, IP Dinámico, IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "Ninguna",
                            content: "Seleccionar si no se proporciona ninguna conexión secundaria."
                        }, {
                            type: "name",
                            title: "IP Dinámico",
                            content: "Seleccionar si la dirección IP y la Máscara de Subred son asignadas automáticamente por el ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Dar clic en este botón para renovar los parámetros de IP de su ISP."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Dar clic en este botón para liberar los parámetros de IP asignados."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Seleccionar si la dirección IP, Máscara de Subred, Puerta de Enlace y direcciones DNS son proporcionados por el ISP, e ingresar esta información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico para la red de Ethernet es 1480 Bytes.",
                    children: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "En un caso raro, su ISP podría requerir ajustar el tamaño del MTU para un mejor desempeño de la red. No debe cambiar este valor a menos que sea absolutamente necesario."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nombre del Servicio / Nombre del Concentrador de Acceso",
                    content: "De manera predeterminada, el Nombre del Servicio y el Nombre del Concentrador de Acceso (AC) se dejan en blanco. Estos campos no deben ser configurados a menos que se requiera por su ISP."
                }, {
                    type: "name",
                    title: "Detectar Intervalo en Línea",
                    content: "Ingresar un valor de intervalo de tiempo entre 0 y 120 (en segundos) para el cual el router detecta al Concentrador de Acceso en línea en cada intervalo. El valor predeterminado es 0, que significa que no hay detección."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Si su ISP proporciona una dirección IP específica (fija), seleccione Usar la siguiente Dirección IP e ingrese la dirección IP en el campo; de otro modo, seleccione Obtener de manera dinámica del ISP para obtener una dirección IP asignada por el servidor de manera automática."
                }, {
                    type: "name",
                    title: "Dirección DNS / DNS Primario / DNS Secundario",
                    content: "Si su ISP proporciona direcciones IP DNS específicas (fijas), seleccione Usar la siguiente Dirección DNS e ingrese las direcciones en los campos de DNS Primario y DNS Secundario respectivamente; de otro modo, seleccione Obtener de manera dinámica del ISP para obtener la(s) dirección(es) IP DNS asignada(s) por el servidor de manera automática."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccionar un modo de conexión adecuado que determine cómo conectarse a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Automático",
                            content: "En este modo, la conexión de Internet se reconecta automáticamente en cualquier momento que se desconecte."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión de Internet finalizará después que haya transcurrido un tiempo específico de inactividad (Tiempo Máximo de Inactividad). La conexión se restablecerá cuando intente tener acceso a Internet de nuevo."
                        }, {
                            type: "name",
                            title: "Basado en el Tiempo",
                            content: "En este modo, la conexión de Internet sólo es establecida en un periodo de tiempo específico. Si se selecciona esta opción, ingrese la hora de inicio y la hora final; ambos están en el formato HH:MM."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión de Internet es controlada manualmente dando clic en el botón de Conectar o Desconectar. Este modo también soporta la función de Tiempo Máximo de Inactividad. Ingrese un tiempo máximo (en minutos) en el cual la conexión de Internet puede estar inactiva antes de que finalice en el campo de Tiempo Máximo de Inactividad. El valor predeterminado es 15 minutos. Si desea que la conexión de Internet permanezca activa todo el tiempo, ingrese 0 (cero)."
                        }, {
                            type: "note",
                            connector: "interfaz?",
                            title: "Nota",
                            content: "El modo de conexión Basada en el Tiempo sólo tomará efecto una vez que se configure el Tiempo del Sistema en la página de Avanzado -> Herramientas del Sistema -> Configuración del Tiempo."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: Cable BigPond"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si su ISP proporciona la conexión del Cable BigPond."
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Servidor de Autenticación",
                    content: "Ingresar la dirección IP del servidor de autenticación o el nombre del host."
                }, {
                    type: "name",
                    title: "Dominio de Autenticación",
                    content: "Ingresar el sufijo del nombre de dominio del servidor (basado en su ubicación). Por ejemplo, nsw.bigpond.net.au para NSW/ACT, vic.bigpond.net.au para VIC/TAS/WA/SA/NT, o qld.bigpond.net.au para QLD."
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico y predeterminado para la mayoría de las redes Ethernet es 1500 Bytes. No se recomienda cambiar el tamaño del MTU predeterminado a menos que se requiera por el ISP."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccionar un modo de conexión adecuado que determine cómo conectarse a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Automático",
                            content: "En este modo, la conexión de Internet se reconecta automáticamente en cualquier momento que se desconecte."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión de Internet finalizará automáticamente después que haya transcurrido de un tiempo específico de inactividad (Tiempo Máximo de Inactividad). La conexión se restablecerá cuando intente acceder de nuevo a Internet."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión de Internet es controlada manualmente dando clic en el botón de Conectar o Desconectar. Este modo también soporta la función de Tiempo Máximo de Inactividad. Ingrese un tiempo máximo (en minutos) que la conexión de Internet puede estar inactiva antes de que finalice en el campo de Tiempo Máximo de Inactividad. El valor predeterminado es 15 minutos. Si desea que la conexión de Internet permanezca activa todo el tiempo, ingrese 0 (cero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si se conecta a un Servidor VPN de L2TP/PPTP y se le proporciona un nombre de usuario, contraseña y la Dirección IP / Nombre de Dominio del servidor por parte del ISP."
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Dirección IP de Internet / DNS Primario / DNS Secundario",
                    content: "Estos parámetros serán asignados de manera automática por el servidor DHCP de su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (IP Dinámico o IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinámico",
                            content: "Seleccionar si la dirección IP y la Máscara de Subred son asignadas automáticamente por el ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Dar clic en este botón para renovar los parámetros de IP de su ISP."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Dar clic en este botón para liberar los parámetros de IP asignados"
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Seleccionar si la dirección IP, la Máscara de Subred, la Puerta de Enlace, y las Direcciones DNS son proporcionadas por el ISP, e ingresar esta información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP del Servidor VPN / Nombre de Dominio",
                    content: "Ingresar la dirección IP del servidor VPN o nombre de dominio proporcionados por su ISP."
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico y predeterminado para la mayoría de las redes Ethernet es 1460 Bytes. NO se recomienda cambiar el tamaño del MTU predeterminado a menos que se requiera por el ISP."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccionar un modo de conexión adecuado que determine cómo conectarse a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Automático",
                            content: "En este modo, la conexión de Internet se reconecta automáticamente en cualquier momento que se desconecte."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión de Internet finalizará automáticamente después que haya transcurrido de un tiempo específico de inactividad (Tiempo Máximo de Inactividad). La reconexión se restablecerá cuando intente acceder de nuevo a Internet"
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión de Internet es controlada manualmente dando clic en el botón de Conectar o Desconectar. Este modo también soporta la función de Tiempo Máximo de Inactividad. Ingrese un tiempo máximo (en minutos) que la conexión de Internet puede estar inactiva antes de que finalice en el campo de Tiempo Máximo de Inactividad. El valor predeterminado es 15 minutos. Si desea que la conexión de Internet permanezca activa todo el tiempo, ingrese 0 (cero)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Lista de Dispositivos Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información de todos los dispositivos powerline que pertenecen a la misma red en el mismo circuito eléctrico"
                }, {
                    type: "name",
                    title: "Dispositivo Local",
                    content: "El extensor powerline en el que está actualmente conectado"
                }, {
                    type: "step",
                    content: ["En la lista de dispositivos powerline, la dirección MAC y la tasa de transmisión de datos del dispositivo correspondiente se muestran de izquierda a derecha. ", "Dar clic en el icono de <b>Papelera de Reciclaje</b> para quitar el dispositivo powerline correspondiente de esta red.", "Dar clic en el icono de <b>Más</b> para agregar un nuevo extensor powerline usando la contraseña de dispositivo para la red powerline."]
                }, {
                    type: "name",
                    title: "Atrás",
                    content: "Dar clic para regresar a la página de Estado."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Dar clic para actualizar la página."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "Clon de MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Usar la Dirección MAC Predeterminada",
                    content: "NO cambiar la dirección MAC predeterminada del router, en caso que el ISP no enlace la dirección IP asignada a la dirección MAC."
                }, {
                    type: "name",
                    title: "Usar la Dirección MAC Actual de la Computadora",
                    content: "Seleccionar para copiar la dirección MAC actual de la computadora que está conectada al router, en caso que el ISP enlace la dirección IP asignada a la dirección MAC de la computadora."
                }, {
                    type: "name",
                    title: "Usar la Dirección MAC Personalizada",
                    content: "Ingresar la Dirección MAC manualmente, en caso que el ISP enlace la dirección IP asignada a la dirección MAC específica."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Configuraciones de LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo de LAN",
                    content: "Seleccionar IP Dinámico o IP Estático."
                }, {
                    type: "name",
                    title: "IP Dinámico",
                    content: "Seleccionar esta opción para obtener automáticamente una dirección IP del servidor DHCP."
                }, {
                    type: "name",
                    title: "IP Estático ",
                    content: "Seleccionar esta opción para especificar manualmente la dirección IP, máscara de subred, y puerta de enlace predeterminada."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP del extensor predeterminado, la cual se usa para ingresar a la página de administración a través de Internet del extensor, y puede ser invalidada."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Seleccionar un identificador asignado usado por el puerto LAN para dirigir el tráfico Interno y Externo desde la lista desplegable o ingresar una nueva máscara de subred en el formato decimal con puntos.  "
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP usada para conectar el extensor a la red."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar todas sus configuraciones"
                }
            ]
        },
        LED_TIME: {
            TITLE: "Horarios de LED",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Los Programas LED le permiten Encender (o Apagar) los LEDs en este extensor powerline de acuerdo a un horario de tiempo específico."
                }, {
                    type: "name",
                    title: "Programador de LED",
                    content: "<b>Activar</b> para habilitar la función de Programador del LED."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Horarios de LED Apagado",
            CONTENT: [
                {
                    type: "name",
                    title: "De",
                    content: "Muestra la hora cuando el LED es Apagado."
                }, {
                    type: "name",
                    title: "A",
                    content: "Muestra la hora cuando el LED se enciende de nuevo."
                }, {
                    type: "name",
                    title: "Día(s) ",
                    content: "Muestra los días efectivos del programa."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Indica el estado actual del programa correspondiente. Dar clic en el icono de <b>Foco</b> para habilitar (o deshabilitar) el programa.  "
                }, {
                    type: "name",
                    title: "Modificar ",
                    content: "Muestra las opciones para <b>Modificar</b> o <b>Borrar</b> el programa correspondiente."
                }, {
                    type: "step",
                    title: "Para crear un horario nuevo",
                    content: ["1. Dar clic en <b>Agregar</b>.", "2. Especificar un rango de tiempo durante el cual el LED se apagará.", "3. Seleccionar el(los) día(s) de la semana cuando el programa es efectivo.", "4. Seleccionar <b>Habilitar esta entrada</b>.", "5. Dar clic en <b>OK</b> para guardar las configuraciones."]
                }, {
                    type: "paragraph",
                    content: "Para modificar o borrar un programa, simplemente dar clic en el icono de <b>Editar</b> para editar la información o el icono de <b>Papelera de Reciclaje</b> para quitar el programa correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para borrar múltiples programas, seleccionar las casilla correspondiente de los programas a ser borrados y dar clic en <b>Borrar</b> arriba de la tabla."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La única dirección física asignada al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Clave Powerline",
                    content: "La única clave de este dispositivo powerline que es usada cuando se está agregando a una red powerline. La contraseña también está impresa en la etiqueta del producto."
                }, {
                    type: "name",
                    title: "Nombre de la Red ",
                    content: "Muestra el nombre de la red powerline a la cual pertenece el extensor powerline. Puede renombrar la red aquí o dar clic en Predeterminado para restablecerlo de nuevo al nombre predeterminado de fábrica, es decir HomePlugAV. Por favor tome en cuenta que si se está usando el nombre predeterminado de fábrica, la característica de Sincronizar Wi-Fi se desactivará automáticamente."
                }
            ]
        },
        IPTV: {
            TITLE: "Configuraciones",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Seleccionar para habilitar la característica de IPTV."
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccionar el modo adecuado de acuerdo a su ISP. Existen seis modos de IPTV soportados:",
                    children: [
                        {
                            type: "name",
                            title: "Puente",
                            content: "Si su ISP no está listado y no se requiere ningún otro parámetro, simplemente seleccione este modo y configure las características del puerto de LAN del router.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Asignar su puerto de LAN ya sea a la función del proveedor de Internet o al proveedor de IPTV."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Rusia",
                            content: "Seleccionar si su ISP es de Rusia y los parámetros necesarios están predeterminados, incluyendo las características de Internet/ Teléfono IP / IDs de VLAN de IPTV y de Prioridad, y el puerto de LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "ID de VLAN / Prioridad de Multidifusión de IPTV ",
                                    content: "Puede habilitar la característica de multidifusión de IPTV según desee, y configurar el ID de VLAN y Prioridad de acuerdo a su ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "ExStream de Singapur",
                            content: "Seleccionar si su ISP es ExStream de Singapur y los parámetros necesarios están predeterminados, incluyendo las características de Internet/ IDs de VLAN de IPTV y de Prioridad, y el puerto de LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Seleccionar si su ISP es Unifi de Malasia y los parámetros necesarios están predeterminados, incluyendo las características de Internet/ IDs de VLAN de IPTV y de Prioridad, y el puerto de LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Seleccionar si su ISP es Maxis de Malasia y los parámetros necesarios están predeterminados, incluyendo las características de Internet / Teléfono IP / IDs de VLAN de IPTV y de Prioridad, y el puerto de LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Personalizado",
                            content: "Seleccionar si su ISP no está listado pero proporciona los parámetros necesarios, incluyendo Internet/ Teléfono IP/ IDs de VLAN de IPTV y de Prioridad, y el puerto de LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/ Teléfono IP/ IDs de VLAN de IPTV / Prioridad ",
                                    content: "Configurar los IDs de VLAN y las prioridades según se proporcionen por su ISP."
                                }, {
                                    type: "name",
                                    title: "Etiqueta 802.11Q ",
                                    content: "Seleccionar para etiquetar los paquetes de Internet con 802.11Q."
                                }, {
                                    type: "name",
                                    title: "ID de VLAN / Prioridad de Multidifusión de IPTV ",
                                    content: "Puede habilitar la característica de multidifusión de IPTV según desee, y configurar el ID de VLAN y la Prioridad de acuerdo a su ISP."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Asigne su puerto de LAN ya sea a la función del proveedor de Internet, o proveedor de IPTV."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Proxy de IGMP",
                    content: "Seleccionar la versión de Proxy de IGMP (Internet Group Management Protocol - Protocolo de Administración de Grupos de Internet), ya sea V2 o V3, de acuerdo a su ISP"
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Configuraciones",
            CONTENT: [
                {
                    type: "name",
                    title: "Servidor DHCP",
                    content: "De manera predeterminada, el Servidor DHCP (Dynamic Host Configuration Protocol - Protocolo de Configuración de Host Dinámico) está habilitado, asigna de manera dinámica los parámetros de TCP/IP a los dispositivos del cliente de un conjunto de Direcciones IP. NO deshabilitar el Servidor DHCP a menos que tenga otro servidor DHCP o desee asignar manualmente los parámetros de TCP/IP a cada dispositivo  cliente en su red."
                }, {
                    type: "name",
                    title: "Grupo de Direcciones IP",
                    content: "Ingresar el rango de direcciones IP que pueden ser arrendadas a los clientes."
                }, {
                    type: "name",
                    title: "Tiempo de Arrendamiento de Direcciones",
                    content: "Ingresar la duración de tiempo que una dirección IP puede ser arrendada al cliente entre 2 y 2880 minutos. El valor predeterminado es 120 minutos"
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "Ingresar la dirección IP de la LAN. (Opcional)"
                }, {
                    type: "name",
                    title: "DNS Primario / DNS Secundario",
                    content: "Ingresar estos parámetros según se proporcionen por su ISP. (Opcional)"
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Reservación de Direcciones",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Puede reservar manualmente una dirección IP para un cliente que está conectado al router. Una vez reservada, la dirección IP sólo será asignada al mismo cliente por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del cliente con Dirección IP Reservada de DHCP."
                }, {
                    type: "name",
                    title: "Dirección IP Reservada",
                    content: "Muestra la Dirección IP Reservada del cliente."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra una descripción del dispositivo del cliente."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) del dispositivo del cliente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar el cliente correspondiente."
                }, {
                    type: "step",
                    title: "Para reservar una dirección IP",
                    content: [
                        "1. Dar clic en Agregar.",
                        "2. Ingresar la dirección MAC de su cliente deseado.",
                        "3. Ingresar la dirección IP que desee reservar para el cliente.",
                        "4. Ingresar una descripción para el cliente.",
                        "5. Seleccionar Habilitar.",
                        "6. Dar clic en OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un cliente existente",
                    content: "En la tabla, dar clic en el ícono de Editar o en el ícono de Borrar que corresponda al cliente que desee modificar o borrar."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Lista de Clientes DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Número de Cliente",
                    content: "Muestra el número de clientes DHCP asociados."
                }, {
                    type: "name",
                    title: "Nombre del Cliente",
                    content: "Muestra el nombre del cliente DHCP."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC."
                }, {
                    type: "name",
                    title: "Dirección IP Asignada",
                    content: "Muestra la dirección IP asignada para el cliente por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Tiempo de Arrendamiento",
                    content: "Muestra la duración de tiempo de la dirección IP que ha sido arrendada para el cliente."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Dar clic para actualizar la Lista de Clientes DHCP."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dinámico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "DNS Dinámico le permite asignar un host fijo y un nombre de dominio a una dirección IP de Internet dinámico. Es útil cuando está alojando su propio sitio web, servidor FTP u otro servidor detrás del router. Primero necesita abrir una cuenta con un proveedor de servicios DDNS como www.dyndns.com."
                }, {
                    type: "step",
                    title: "Para configurar un DNS Dinámico",
                    content: ["1. Seleccione su proveedor de servicios de DDNS Dinámico.", "2. Ingrese el Nombre de Usuario y Contraseña de su cuenta de DDNS Dinámico.", "3. Ingrese el Nombre de Dominio que recibió del proveedor de servicios de DDNS Dinámico.", "4. Seleccione su Intervalo de Actualización de la lista desplegable.", "5. Dar clic en Iniciar Sesión y Guardar."]
                }, {
                    type: "paragraph",
                    content: "Para cambiar entre cuentas, primero debe Finalizar la Sesión de la cuenta actual y después Iniciar Sesión con la otra cuenta con el nombre de usuario y contraseña nuevos."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Enrutamiento Estático",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El enrutamiento estático se usa para predeterminar una ruta fija para los paquetes de información de la red para alcanzar un host o red específicos."
                }, {
                    type: "step",
                    title: "Para configurar un Enrutamiento Estático",
                    content: [
                        "1. Dar clic en Agregar.",
                        "2. Red Destino - Ingresar una dirección IP en formato hexadecimal para asignar la ruta estática para esta entrada.",
                        "3. Máscara de Subred - Ingresar una máscara de subred en formato hexadecimal para determinar la parte de la red y la parte del host de la dirección IP.",
                        "4. Puerta de Enlace Predeterminada - Ingresar una dirección IP de la puerta de enlace en formato hexadecimal  para conectar el router a la red o al host.",
                        "5. Interfaz - Seleccionar LAN o WAN para especificar el tipo de la Red Destino.",
                        "6. Descripción - Ingresar una descripción breve para esta entrada.",
                        "7. Seleccionar Habilitar.",
                        "8. Dar clic en OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una entrada existente",
                    content: "En la tabla, dar clic en el ícono de Editar o en el ícono  de Borrar que corresponda a la entrada que desee modificar o borrar."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Tabla de Enrutamiento del Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Tabla de Enrutamiento del Sistema muestra todas las entradas de rutas válidas que están actualmente en uso."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Actualizar para actualizar la tabla de enrutamiento."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Configuraciones",
            CONTENT: [
                {
                    type: "name",
                    title: "Región",
                    content: "Seleccione su región del menú desplegable. Si su país o región no está listado, puede ser que esté restringido el uso de la radio inalámbrica en su localidad."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar todas sus configuraciones"
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Inalámbrico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Las instrucciones proporcionadas a continuación son para redes inalámbricas <span class=\"anti_5g\">tanto de 2.4GHz como de 5GHz </span>"
                }, {
                    type: "name",
                    title: "Habilitar Radio Inalámbrico",
                    content: "Seleccionar esta casilla de verificación para habilitar la frecuencia de radio inalámbrica ."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Puede dejar el Nombre de la Red (SSID) predeterminado como está, o crear un nombre nuevo (hasta 32 caracteres). Este campo hace distinción entre mayúsculas y minúsculas. "
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccionar esta casilla de verificación si desea ocultar el nombre de la red  (SSID) de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña del inalámbrico entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Dar clic para mostrar configuraciones más avanzadas."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccionar una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccionar esta opción para deshabilitar la seguridad inalámbrica.  Se <b>recomienda ampliamente</b> que habilite la seguridad inalámbrica para proteger su red inalámbrica del acceso no autorizado.  "
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccionar esta opción para habilitar el método de Autenticación estándar basado en una PSK (Pre-shared Key - Clave pre-compartida), también llamada frase de contraseña. Se recomienda esta opción. Si se selecciona, configurar lo siguiente.  ",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccionar una versión de seguridad para su red inalámbrica. ",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automático",
                                            content: "Esta opción soporta múltiple implementación del WPA (Wi-Fi Protected Access - Acceso Wi-Fi protegido) estándar, como WPA y WPA2. "
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción soporta encriptaciones de TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccionar un tipo de encriptación de seguridad: <b>TKIP</b> (Temporal Key Integrity Protocol - Protocolo de Integridad de Clave Temporal), o <b>AES</b> (Advanced Encryption Standard - Estándar de Encriptación Avanzada), o <b>Auto </b> (tanto para TKIP como AES). <b>NO</b> se recomienda usar la encriptación  de TKIP si el extensor powerline opera en el modo 802.11n, ya que TKIP no está soportado por la especificación de 802.11n. "
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccionar esta opción para habilitar el método de autenticación básico si alguno sus dispositivos cliente sólo pueden tener acceso al inalámbrico usando WEP (Wired Equivalent Privacy - Privacidad Equivalente al Cableado).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccionar un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, el cual escoge automáticamente <b>Sistema Abierto</b>  o <b>Clave Compartida</b> basándose en la capacidad y solicitud de acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccionar una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Usar el formato <b>ASCII</b> o <b>Hexadecimal</b>. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccionar una longitud de la clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Le permite ingresar 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Le permite ingresar 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccionar un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccionar un ancho de canal (ancho de banda) para la red inalámbrica correspondiente."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Seleccionar un canal de operación para la red inalámbrica correspondiente. Se recomienda dejar el canal en <b>Auto</b>, si no está experimentando un problema de conexión inalámbrica intermitente."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccionar <b>Alto</b>, <b>Medio</b>, o <b>Bajo</b> para especificar la potencia de transmisión de datos. La configuración predeterminada y recomendada es <b>Alto</b>."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar todas sus configuraciones."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Inalámbrico de 2.4GHz ",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Radio Inalámbrico",
                    content: "Seleccionar esta casilla de verificación para habilitar la frecuencia de radio inalámbrica de 2.4GHz."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Puede dejar el Nombre de la Red (SSID) predeterminado como está, o ingresar un nombre nuevo (hasta 32 caracteres). Este campo hace distinción entre mayúsculas y minúsculas. "
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccionar esta casilla de verificación si desea ocultar el nombre de la red (SSID) de 2.4GHz  de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña del inalámbrico entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Dar clic para mostrar configuraciones más avanzadas."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccionar una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccionar esta opción para deshabilitar la seguridad inalámbrica.  Se <b>recomienda ampliamente</b> que habilite la seguridad inalámbrica para proteger su red inalámbrica del acceso no autorizado.  "
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccionar esta opción para habilitar el método de autenticación estándar basado en una PSK (Pre-shared Key - Clave pre-compartida), también llamada frase de contraseña. Se recomienda esta opción. Si se selecciona, configurar lo siguiente.  ",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccionar una versión de seguridad para su red inalámbrica. ",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automático",
                                            content: "Esta opción soporta múltiple implementación del WPA (Wi-Fi Protected Access - Acceso Wi-Fi protegido) estándar, como WPA y WPA2. "
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción soporta encriptaciones de TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción soporta la encriptación de AES que proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccionar un tipo de encriptación de seguridad: <b>TKIP</b> (Temporal Key Integrity Protocol - Protocolo de Integridad de Clave Temporal), o <b>AES</b> (Advanced Encryption Standard - Estándar de Encriptación Avanzada), o <b>Auto </b> (tanto para TKIP como AES). <b>NO</b> se recomienda usar la encriptación  de TKIP si el extensor powerline opera en el modo 802.11n, ya que TKIP no está soportado por la especificación de 802.11n. "
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccionar esta opción para habilitar el método de autenticación básico si alguno sus dispositivos cliente sólo pueden tener acceso al inalámbrico usando WEP (Wired Equivalent Privacy - Privacidad Equivalente al Cableado).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccionar un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, el cual escoge automáticamente <b>Sistema Abierto</b>  o <b>Clave Compartida</b> basándose en la capacidad y solicitud de acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccionar una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Usar el formato ASCII  o Hexadecimal. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccionar una longitud de la clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Le permite ingresar 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Le permite ingresar 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccionar un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccionar un ancho de canal (ancho de banda) para la red inalámbrica  de 2.4GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Seleccionar un canal de operación para la red inalámbrica de 2.4GHz. Se recomienda dejar el canal en <b>Auto</b>, si no está experimentando un problema de conexión inalámbrica intermitente."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccionar <b>Alto</b>, <b>Medio</b>, o <b>Bajo</b> para especificar la potencia de transmisión de datos. La configuración predeterminada y recomendada es <b>Alto</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Inalámbrico de 5GHz ",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Radio Inalámbrico",
                    content: "Seleccionar esta casilla de verificación para habilitar la frecuencia de radio inalámbrica de 5GHz."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Puede dejar el Nombre de la Red (SSID) predeterminado como está, o crear un nombre nuevo (hasta 32 caracteres). Este campo hace distinción entre mayúsculas y minúsculas. "
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccionar esta casilla de verificación si desea ocultar el nombre de la red (SSID) de 5GHz  de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña del inalámbrico entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Dar clic para mostrar configuraciones más avanzadas."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccionar una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccionar esta opción para deshabilitar la seguridad inalámbrica.  Se <b>recomienda ampliamente</b> que habilite la seguridad inalámbrica para proteger su red inalámbrica del acceso no autorizado.  "
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccionar esta opción para habilitar el método de autenticación estándar basado en una PSK (Pre-shared Key - Clave pre-compartida), también llamada frase de contraseña. Se recomienda esta opción. Si se selecciona, configurar lo siguiente.  ",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccionar una versión de seguridad para su red inalámbrica. ",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automático",
                                            content: "Esta opción soporta múltiple implementación del WPA (Wi-Fi Protected Access - Acceso Wi-Fi protegido) estándar, como WPA y WPA2. "
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción soporta encriptaciones de TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción soporta la encriptación de AES que proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccionar un tipo de encriptación de seguridad: <b>TKIP</b> (Temporal Key Integrity Protocol - Protocolo de Integridad de Clave Temporal), o <b>AES</b> (Advanced Encryption Standard - Estándar de Encriptación Avanzada), o <b>Auto </b> (tanto para TKIP como AES). <b>NO</b> se recomienda usar la encriptación  de TKIP si el extensor powerline opera en el modo 802.11n, ya que TKIP no está soportado por la especificación de 802.11n. "
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccionar esta opción para habilitar el método de autenticación básico si alguno sus dispositivos cliente sólo pueden tener acceso al inalámbrico usando WEP (Wired Equivalent Privacy - Privacidad Equivalente al Cableado).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccionar un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, el cual escoge automáticamente <b>Sistema Abierto</b>  o <b>Clave Compartida</b> basándose en la capacidad y solicitud de acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccionar una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Usar el formato <b>ASCII</b> o <b>Hexadecimal</b>. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccionar una longitud de la clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Le permite ingresar 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Le permite ingresar 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccionar un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccionar un ancho de canal (ancho de banda) para la red inalámbrica  de 5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Seleccionar un canal de operación para la red inalámbrica de 5GHz. Se recomienda dejar el canal en Auto, si no está experimentando un problema de conexión inalámbrica intermitente."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccionar Alto, Medio, o Bajo para especificar la potencia de transmisión de datos. La configuración predeterminada y recomendada es Alto."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar todas sus configuraciones."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Horarios de Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Los Horarios de Wi-Fi le permiten establecer tiempos específicos para apagar Wi-Fi."
                }, {
                    type: "name",
                    title: "Programador de Wi-Fi",
                    content: "<b>Activar</b> para habilitar la característica de Horarios de Wi-Fi. Si desea permanecer en la Wi-Fi en dispositivos inalámbricos mientras aún está conectado a la red inalámbrica, seleccione la casilla de verificación."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Clon de Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Clon de Wi-Fi se usa para copiar las configuraciones inalámbricas (incluyendo el SSID y la contraseña inalámbrica) del router inalámbrico principal hacia el extensor."
                }, {
                    type: "name",
                    title: "Selección de la Banda de Wi-Fi",
                    content: "Seleccionar una <span class=\"anti_5g\">o las dos </span> a ser clonadas. <span class=\"anti_5g\"> Si el router principal sólo soporta clonar una banda a la vez, le recomendamos que seleccione 2.4GHz y 5GHz aquí para asegurarse que la banda clonada sea consistente con la banda permitida por su router.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Horarios de Apagado de Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "De",
                    content: "Muestra la hora cuando el Wi-Fi es Apagado."
                }, {
                    type: "name",
                    title: "A",
                    content: "Muestra la hora cuando el Wi-Fi se enciende de nuevo."
                }, {
                    type: "name",
                    title: "Día(s) ",
                    content: "Muestra los días efectivos del horario."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Indica si el horario está activo o no. Dar clic en el icono de Foco para habilitar (o deshabilitar) el horario.  "
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para <b>Modificar</b> o <b>Borrar</b> la entrada correspondiente."
                }, {
                    type: "step",
                    title: "Para agregar un horario nuevo",
                    content: ["1. Dar clic en <b>Agregar</b>.", "2. Especificar un rango de tiempo durante el cual el Wi-Fi se apagará.", "3. Seleccionar el(los) día(s).", "4. Seleccionar <b>Habilitar esta entrada</b>.", "5. Dar clic en <b>OK</b> para guardar esta entrada."]
                }, {
                    type: "paragraph",
                    content: "Para modificar o borrar una entrada de Wi-Fi, simplemente dar clic en el icono de <b>Editar</b> para  editar la información o el icono de <b>Papelera de Reciclaje</b> para quitar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para borrar múltiples programas, seleccionar todos los horarios  y dar clic en <b>Borrar</b> arriba de la tabla."
                }
            ]
        },
        WPS: {
            TITLE: "PIN del Router",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Otros dispositivos pueden conectarse a este router mediante WPS con el PIN del Router"
                }, {
                    type: "name",
                    title: "Habilitar el PIN del Router",
                    content: "Activar para permitir que los dispositivos inalámbricos se conecten al router usando el PIN (Personal Identification Number - Número de Identificación Personal) del Router."
                }, {
                    type: "name",
                    title: "PIN del Router",
                    content: "Muestra el PIN del Router. El PIN predeterminado se puede encontrar en la etiqueta del router o en la Guía del Usuario. Dar clic en Generar para generar un nuevo PIN al azar o dar clic en Default (Predeterminado) para restaurar el PIN actual al PIN  predeterminado de fábrica."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "Asistente de WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccionar un método de configuración "
                }, {
                    type: "name",
                    title: "Presionar Botón (Recomendado)",
                    content: "Seleccionar este método de configuración para habilitar la característica de WPS para conectar fácilmente cualquier dispositivo habilitado con WPS a su red inalámbrica usando el botón WPS o usando de manera virtual el botón de Conectar."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Seleccionar este método de configuración para agregar un dispositivo de manera manual ingresando el PIN de WPS del dispositivo inalámbrico en el campo y dar clic en Conectar."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Clientes Inalámbricos en Línea",
            CONTENT: [
                {
                    type: "name",
                    title: "Clientes Totales",
                    content: "Muestra el número total de clientes inalámbricos conectados a la red powerline."
                }, {
                    type: "name",
                    title: "Nombre del Dispositivo",
                    content: "Muestra el nombre del cliente inalámbrico. "
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP del cliente inalámbrico está utilizando."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: " Muestra la dirección MAC del cliente inalámbrico."
                }, {
                    type: "name",
                    title: "Banda Inalámbrica",
                    content: " Muestra la banda de frecuencia <span class=\"anti_5g\">(2.4GHz o 5GHz) </span> de la red inalámbrica a la que el cliente inalámbrico está conectado"
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Muestra el tipo de seguridad del cliente inalámbrico. "
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Actualizar</b> para actualizar la información de esta página."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Red para Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La <b>Red para Invitados</b> le permite tener nombres de red inalámbrica (SSID) y contraseñas separados que los invitados pueden usar para tener acceso a Internet"
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Red para Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La <b>Red para Invitados</b> le permite tener nombres de red inalámbrica (SSID) y contraseñas separados que los invitados pueden usar para tener acceso a Internet"
                }, {
                    type: "name",
                    title: "Permitir que los invitados se vean entre sí",
                    content: "Seleccionar esta casilla de verificación para permitir que los dispositivos inalámbricos en la Red para Invitados se intercomuniquen entre sí."
                }, {
                    type: "name",
                    title: "No permitir que los invitados administren mi red",
                    content: "Seleccionar esta opción para evitar que los invitados inicien sesión en las interfaces de administración a través de Internet. "
                }, {
                    type: "name",
                    title: "Deshabilitar automáticamente después de",
                    content: "Seleccionar esta opción para desactivar automáticamente la Red para Invitados basándose  en el tiempo específico. "
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar todas sus configuraciones."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Configuraciones de la Red para Invitados",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Alternar entre 2.4GHz y 5GHz para mostrar sus configuraciones."
                }, {
                    type: "name",
                    title: "Habilitar la Red para Invitados",
                    content: "Seleccionar esta casilla de verificación para habilitar la Red para Invitados."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Usar la opción predeterminada de SSID de Invitado o crear un nombre nuevo (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccionar una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccionar esta opción para deshabilitar la seguridad inalámbrica.  Se <u><b>recomienda ampliamente</b></u> que habilite la seguridad inalámbrica para proteger su Red para Invitados del acceso no autorizado.  "
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccionar esta opción para habilitar el método de autenticación estándar basado en una PSK (Pre-shared Key - Clave pre-compartida), también llamada frase de contraseña. Si se selecciona, configurar lo siguiente.  "
                        }
                    ]
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Usar la contraseña predeterminada o crear  una contraseña entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar sus configuraciones inalámbricas de la Red para Invitados."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Configuraciones de la Red para Invitados",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar la Red para Invitados",
                    content: "Seleccionar esta casilla de verificación para habilitar la Red para Invitados."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Usar la opción predeterminada de SSID de Invitado o crear un nombre nuevo (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccionar una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccionar esta opción para deshabilitar la seguridad inalámbrica.  Se <u><b>recomienda ampliamente</b></u> que habilite la seguridad inalámbrica para proteger su Red para Invitados del acceso no autorizado.  "
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccionar esta opción para habilitar el método de autenticación estándar basado en una PSK (Pre-shared Key - Clave pre-compartida), también llamada frase de contraseña. Si se selecciona, configurar lo siguiente.  "
                        }
                    ]
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Usar la contraseña predeterminada o crear  una contraseña entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar sus configuraciones inalámbricas de la Red para Invitados."
                }
            ]
        },
        NAT: {
            TITLE: "ALG (Application Layer Gateway - Puerta de Enlace de Capa de Aplicación)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG permite que los filtros transversales de NAT (Network Address Translation - Traducción de Dirección de Red) sean conectados a la puerta de enlace para soportar la dirección y la traducción del puerto para ciertos protocolos de \"control/datos\" de la capa de aplicación: FTP, TFTP, H323 etc. Se recomienda habilitar ALG."
                }, {
                    type: "name",
                    title: "Habilitar FTP ALG",
                    content: "Si se selecciona, permite que los clientes y servidores de FTP (File Transfer Protocol - Protocolo de Transferencia de Archivos) transfieran datos mediante NAT."
                }, {
                    type: "name",
                    title: "Habilitar TFTP ALG",
                    content: "Si se selecciona, permite que los clientes y servidores de TFTP (Trivial File Transfer Protocol - Protocolo de Transferencia de Archivos Trivial) transfieran datos mediante NAT."
                }, {
                    type: "name",
                    title: "Habilitar H323 ALG",
                    content: "Si se selecciona, permite que los clientes de Microsoft NetMeeting se comuniquen mediante NAT."
                }, {
                    type: "name",
                    title: "Habilitar RTSP ALG",
                    content: "Si se selecciona, permite que los clientes de reproductores multimedia se comuniquen con los servidores de multimedia simultánea mediante NAT."
                }, {
                    type: "name",
                    title: "Habilitar la Transferencia de PPTP",
                    content: "Si se selecciona, permite que las sesiones de Punto a Punto sean tunelizadas a través de una red IP y que pasen a través del router."
                }, {
                    type: "name",
                    title: "Habilitar la Transferencia de L2TP",
                    content: "Si se selecciona, permite que las sesiones de Punto a Punto de Capa 2 sean tunelizadas a través de una red IP y que pasen a través del router."
                }, {
                    type: "name",
                    title: "Habilitar la Transferencia de  IPSec",
                    content: "Si se selecciona, permite que la seguridad del Protocolo de Internet (IPSec) sea tunelizada a través de una red IP y que pase a través del router. IPSec usa servicios de seguridad criptográficos para asegurar comunicaciones privadas y seguras a través de las redes de IP."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar todas sus configuraciones"
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Servidores Virtuales",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Los Servidores Virtuales se usan para configurar los servicios públicos en su red local. Un servidor virtual se define como un puerto externo, y todas las solicitudes de Internet a este puerto externo serán redirigidas a una computadora designada, la cual debe estar configurada con una dirección IP estática o reservada."
                }, {
                    type: "name",
                    title: "Tipo de Servicio",
                    content: "Muestra el nombre de su servidor virtual."
                }, {
                    type: "name",
                    title: "Puerto Externo",
                    content: "Muestra el número de puerto o un rango de puertos usados por el servidor virtual."
                }, {
                    type: "name",
                    title: "IP Interno",
                    content: "Muestra la dirección IP de la computadora que ejecuta la aplicación del servicio."
                }, {
                    type: "name",
                    title: "Puerto Interno",
                    content: "Muestra el número de puertos de la computadora que ejecuta la aplicación del servicio."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Muestra el protocolo usado para la aplicación del servicio: TCP, UDP, o Todos (Todos los protocolos soportados por el router).."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) de la regla de filtrado específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar la regla correspondiente."
                }, {
                    type: "step",
                    title: "Para configurar una regla del Servidor Virtual",
                    content: ["1. Dar clic en Agregar.", "2. Dar Clic en Ver Servicios Existentes para seleccionar un servicio de la lista para llenar automáticamente el número de puerto adecuado en los campos del Puerto Externo y Puerto Interno. Si el servicio no está listado, ingresar el número de puerto externo (ejemplo, 21) o un rango de puertos (ejemplo, 21-25). Dejar el Puerto Interno en blanco si es el mismo que el Puerto Externo o ingresar un número de puerto específico (ejemplo, 21) si el Puerto Externo es un puerto único. Ingresar la dirección IP de la computadora que ejecuta la aplicación del servicio en el formato de notación decimal con puntos en el campo de IP Interno.", "3. Seleccionar un protocolo para la aplicación del servicio: TCP, UDP, o Todo de la lista desplegable de Protocolo.", "4. Seleccionar Habilitar.", "5. Dar clic en OK."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una regla del Servidor Virtual",
                    content: "Dar clic en el ícono de Modificar o en el ícono de Papelera de Reciclaje que corresponda a la regla que desee modificar o borrar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples reglas",
                    content: "Seleccionar todas las entradas que desee borrar, dar clic en Borrar arriba de la tabla."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si su dispositivo de host local está alojando más de un tipo de servicios disponibles, necesita crear una regla para cada servicio. "
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Activación de Puertos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Activación de Puertos se usa para reenviar el tráfico de cierto puerto a un servidor específico en la red. "
                }, {
                    type: "name",
                    title: "Aplicación",
                    content: "Muestra el nombre de la aplicación."
                }, {
                    type: "name",
                    title: "Puerto de Activación",
                    content: "Muestra el puerto de tráfico saliente usado para activar una regla de filtrado de una conexión saliente. "
                }, {
                    type: "name",
                    title: "Protocolo de Activación",
                    content: "Muestra el protocolo usado para el Puerto de Activación. TCP, UDP, o Todos (Todos los protocolos soportados por el router)."
                }, {
                    type: "name",
                    title: "Puerto Externo",
                    content: "Muestra el puerto o rango de puertos usados por el sistema remoto. Una respuesta que usa uno de estos puertos será reenviada a la PC que activa esta regla. Puede ingresar 5 grupos de puertos (o secciones de puertos) como máximo. Cada grupo de puertos debe estar separado con \",\" (comas), por ejemplo, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Protocolo Externo",
                    content: "Muestra el protocolo usado del Puerto Entrante: TCP, UDP, o TODOS (Todos los protocolos soportados por el router)."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) de la regla de filtrado específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar y la regla correspondiente."
                }, {
                    type: "step",
                    title: "Para configurar una regla de Activación de Puerto",
                    content: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "Cada regla sólo puede ser usada por un host a la vez."
                        },
                        "1. Dar clic en Agregar.", {
                            content: "2.Dar Clic en Ver Aplicaciones Existentes para seleccionar una aplicación de la lista para llenar automáticamente los valores predeterminados en los campos adecuados. Si desea agregar una aplicación no listada, ingrese de manera manual la Aplicación, Puerto de Activación, Protocolo de Activación, Puerto Externo y Protocolo Externo.",
                            children: [
                                {
                                    type: "note",
                                    title: "Nota",
                                    content: "Las reglas no pueden tener ningún puerto que se superponga entre sí (por ejemplo, la Regla 1 tiene el rango de puertos 4200-4205, lo que significa que la Regla 2 no puede tener un rango de puertos entre 4203-4206)"
                                }
                            ]
                        },
                        "3. Seleccionar Habilitar.",
                        "4. Dar clic en OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una regla de Activación del Puerto",
                    content: "En la tabla, dar clic en el ícono de Modificar o en el ícono de Papelera de Reciclaje que corresponda a la regla que desee modificar o borrar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples reglas de Activación del Puerto",
                    content: "En la tabla, seleccione todas las reglas que desea borrar, dar clic en Borrar arriba de la tabla."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La característica del host de DMZ (Demilitarized Zone - Zona Desmilitarizada) permite que un host local sea expuesto a Internet para un servicio de propósito especial, como videojuegos en línea o videoconferencias. Básicamente, el DMZ permite que una sola computadora en su LAN abra todos sus puertos. Esta computadora necesita estar configurada con una dirección IP estática y tener su función de cliente DHCP deshabilitada. "
                }, {
                    type: "step",
                    title: "Para asignar una computadora o servidor para que sea un servidor DMZ",
                    content: ["1. Haga clic en Habilitar DMZ. ", "2. En el campo de Dirección IP del Host de DMZ introduzca la Dirección IP de una computadora local para configurar como el host de DMZ. ", "3. Dar clic en Guardar."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "De manera predeterminada, la característica de UPnP (Universal Plug and Play - Conexión y Funcionamiento Universal) está habilitada para permitir que dispositivos como computadoras y dispositivos que usan Internet descubran y se comuniquen automáticamente entre sí en la red local."
                }, {
                    type: "paragraph",
                    content: "La Lista de Servicios de UPnP muestra la información del dispositivo UPnP."
                }, {
                    type: "name",
                    title: "Descripción del Servicio",
                    content: "Muestra una breve descripción del host local que inicia la solicitud UPnP."
                }, {
                    type: "name",
                    title: "Protocolo Externo",
                    content: "Muestra el puerto externo que es abierto por el host local."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Muestra el tipo de protocolo de la red que es usado por el host local. "
                }, {
                    type: "name",
                    title: "Dirección IP Interna",
                    content: "Muestra la dirección IP del host local."
                }, {
                    type: "name",
                    title: "Puerto Interno",
                    content: "Muestra el puerto interno que es abierto por el host local."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Actualizar para actualizar la Lista del Servidor UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Configuraciones del Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página de Configuraciones del Dispositivo muestra la información relacionada de cualquier dispositivo de almacenamiento USB conectado mediante el puerto USB."
                }, {
                    type: "name",
                    title: "Escanear",
                    content: "Generalmente el router detecta automáticamente cualquier dispositivo recién conectado. De lo contrario, dar clic en este botón para buscar cualquier dispositivo nuevo conectado y actualizar la página con la información actualizada. "
                }, {
                    type: "name",
                    title: "Volumen",
                    content: "Muestra el nombre del volumen USB."
                }, {
                    type: "name",
                    title: "Capacidad",
                    content: "Muestra la capacidad total de almacenamiento del USB."
                }, {
                    type: "name",
                    title: "Espacio Libre",
                    content: "Muestra el espacio de almacenamiento libre disponible actual."
                }, {
                    type: "name",
                    title: "Retirar de Forma Segura",
                    content: "Dar clic en este botón para retirar de manera segura el dispositivo de almacenamiento USB antes de desconectarlo físicamente del router."
                }, {
                    type: "paragraph",
                    content: "Por favor tome en cuenta que el botón de Retirar de Manera Segura sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router, y no podrá retirar el dispositivo USB mientras el volumen actual está ocupado."
                }, {
                    type: "name",
                    title: "Activar",
                    content: "Esta tabla sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. Seleccionar para habilitar el uso compartido de archivos del dispositivo USB."
                }, {
                    type: "step",
                    title: "Para configurar un servidor de archivos",
                    content: ["1. Conectar el dispositivo de almacenamiento USB al puerto USB del router usando un cable USB.", "2. El dispositivo USB recién conectado debe ser detectado automáticamente por el router y se debe mostrar la información en la sección de Configuraciones del Dispositivo. De lo contrario, dar clic en Escanear.", "3. Seleccionar Activar para habilitar el uso compartido de archivos."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Cuenta de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Cuenta",
                    content: "Puede seleccionar Usar Cuenta Predeterminada para tener acceso a los archivos y carpetas compartidas o Usar Cuenta Nueva e ingresar lo siguiente para crear una nueva cuenta de usuario."
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar una cadena alfanumérica o subrayada de hasta 15 caracteres de longitud. El nombre de usuario debe iniciar con un carácter del alfabeto. Estos campos hacen distinción entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Confirmar Contraseña",
                    content: "Volver a ingresar la contraseña para confirmar que no haya ningún error tipográfico. Este campo también hace distinción entre mayúsculas y minúsculas."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar la nueva cuenta de usuario."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Configuraciones de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre del Servidor Multimedia / Red",
                    content: "Muestra el nombre usado para acceder dispositivo de almacenamiento USB conectado."
                }, {
                    type: "name",
                    title: "Habilitar",
                    content: "Seleccionar para habilitar el método de acceso."
                }, {
                    type: "name",
                    title: "Método de Acceso",
                    content: "Existen tres métodos de acceso para permitir el acceso al dispositivo de almacenamiento USB conectado. Puede seleccionar uno o más métodos de acceso seleccionando la casilla de verificación correspondiente.",
                    children: [
                        {
                            type: "name",
                            title: "Mis Sitios de Red",
                            content: "Si se habilita, los usuarios en su red pueden tener acceso al dispositivo de almacenamiento USB usando una dirección IP asignada (ejemplo, \\\\192.168.0.1). Este método está habilitado de manera predeterminada."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Si se habilita, los clientes de FTP en su red local pueden tener acceso al dispositivo de almacenamiento USB usando una dirección IP asignada, seguida por el número de puerto del servidor FTP (ejemplo, ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (a través de Internet)",
                            content: "Si se habilita, los usuarios pueden tener acceso de manera remota a la unidad de almacenamiento USB mediante FTP a través de Internet. Esta característica soporta tanto descargar como subir archivos. Para cambiar el número de puerto del servidor, ingresar un número de puerto y dar clic en Guardar para aplicar los cambios."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Vínculo",
                    content: "Muestra la dirección usada para tener acceso al dispositivo de almacenamiento USB compartido."
                }, {
                    type: "name",
                    title: "Puerto",
                    content: "Muestra el número de puerto del servidor FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Uso Compartido de Carpetas",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartir Todo",
                    content: "Activar para compartir todos los archivos y carpetas o Desactivar para sólo compartir las carpetas seleccionadas. "
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Se recomienda ampliamente habilitar la autenticación para requerir que los usuarios ingresen un nombre de usuario y contraseña válidos para tener acceso a todas las carpetas compartidas"
                }, {
                    type: "name",
                    title: "Nombre de la Carpeta",
                    content: "Muestra el nombre de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Ruta de la Carpeta",
                    content: "Muestra la ruta hacia la carpeta compartida."
                }, {
                    type: "name",
                    title: "Uso Compartido de Multimedia",
                    content: "Indica si la carpeta compartida permite el uso compartido de multimedia o no."
                }, {
                    type: "name",
                    title: "Nombre del Volumen",
                    content: "Muestra el nombre del volumen compartido."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado de la carpeta compartida mediante el indicador de foco. Verde (Encendido) está activado y Gris (Apagado) está desactivado. Puede habilitar o deshabilitar el uso compartido dando clic en el foco."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar la carpeta compartida correspondiente."
                }, {
                    type: "name",
                    title: "Examinar",
                    content: "Dar clic en buscar una carpeta de uso compartido."
                }, {
                    type: "name",
                    title: "Permitir el Acceso a la Red para Invitados",
                    content: "Seleccionar para permitir que los clientes en la Red para Invitados tengan acceso a las carpetas de uso compartido."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Seleccionar para requerir que los usuarios tengan acceso a las carpetas de uso compartido con un nombre de usuario y contraseña válidos."
                }, {
                    type: "name",
                    title: "Habilitar el Acceso de Escritura",
                    content: "Seleccionar para permitir que los usuarios realicen cambios al contenido de la carpeta."
                }, {
                    type: "name",
                    title: "Habilitar el Uso Compartido de Multimedia",
                    content: "Seleccionar para habilitar el uso compartido de multimedia."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Servidor de Impresión",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar un Servidor de Impresión que puede ser usado en toda su red",
                    content: ["1 .Conectar una impresora USB al puerto USB del router mediante un cable USB.", "2. Instalar el controlador de la impresora en su computadora. Consultar los manuales del fabricante de la computadora para ver las instrucciones.", "3. Instalar la Herramienta del Controlador de la Impresora USB de TP-LINK, ya sea del CD de Recursos (para Windows únicamente) o puede descargarla (tanto para Windows como para Mac OS X) desde el sitio web oficial de TP-LINK."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Controles Parentales",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con Controles Parentales, puede establecer límites de tiempo para dispositivos inalámbricos y controlar cuándo estos dispositivos pueden acceder a Internet. "
                }, {
                    type: "name",
                    title: "Controles Parentales",
                    content: "<b>Activar</b> para habilitar la característica de Controles Parentales."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Dispositivos Bajo Controles Parentales",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "ID - Muestra el ID del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Dirección MAC  - Muestra las direcciones MAC del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Tiempo de Acceso a Internet",
                    content: "Tiempo de Acceso a Internet  - Muestra los periodos de tiempo de acceso permitidos."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Descripción - Muestra una breve descripción del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Estado - Indica si los Controles Parentales están activados o no para el dispositivo correspondiente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Modificar - Muestra las opciones para Modificar o Borrar el dispositivo."
                }, {
                    type: "step",
                    title: "Para establecer el límite de tiempo para un dispositivo de cliente nuevo",
                    content: [
                        "1. Dar clic en <b>Agregar</b>.",
                        "2. Dar clic en <b>Ver Dispositivos Existentes</b> y seleccionar un dispositivo conectado actualmente de la Lista de <b>Dispositivos con Acceso Inalámbrico</b>; o ingresar la <b>Dirección MAC</b> manualmente para agregar un dispositivo que no esté conectado.",
                        "3. Dar clic en el icono de <b>Tiempo de Acceso a Internet</b> para especificar los rangos de tiempo durante los cuales el dispositivo tiene permitido tener acceso a Internet.",
                        "4. Ingresar una breve descripción en el campo de <b>Descripción</b>. Este campo es opcional.",
                        "5. Seleccionar <b>Habilitar esta entrada</b>.",
                        "6. Dar clic en <b>OK</b> para guardar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar o borrar un dispositivo de la lista, simplemente dar clic en el icono de <b>Editar</b> para  editar la información o el icono de <b>Papelera de Reciclaje</b> para quitar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para borrar múltiples dispositivos de la lista, seleccionar la casilla correspondiente de los dispositivos a ser borrados y dar clic en <b>Borrar</b> arriba de la tabla."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restricción de Contenido",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Contiene palabras clave que se usarán para bloquear cualquier acceso al sitio de Internet de los dispositivos cliente especificados en la lista de Controles Parentales. ",
                    children: [
                        {
                            type: "paragraph",
                            content: "Dar clic en Agregar una Palabra Clave Nueva para agregar una palabra clave a la lista negra. Para borrar una palabra clave, dar clic en el icono de (-) de la palabra clave que desea borrar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Lista Blanca",
                    content: "Contiene las direcciones de los sitios de Internet a los cuales tienen permitido el acceso los dispositivos de cliente especificados en la lista de Controles Parentales.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Dar clic en Agregar un Nombre de Dominio Nuevo para agregar un sitio de Internet a la lista blanca. Para borrar un sitio de Internet, dar clic en el icono de (-) del sitio de Internet que desea borrar."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Las Palabras Clave también pueden ser nombres de dominio, por ejemplo,  www.mail.google.com o www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar su configuración."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "QoS (Quality of Service - Calidad del Servicio) ayuda a priorizar el tráfico de Internet basado en sus necesidades. Puede especificar el nivel de prioridad para un dispositivo o una aplicación en la lista de reglas de QoS."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si se habilita NAT Boost, se debe deshabilitar QoS."
                }, {
                    type: "name",
                    title: "Habilitar QoS",
                    content: "Seleccionar esta casilla para habilitar la función de QoS."
                }, {
                    type: "name",
                    title: "Ancho de Banda de Carga",
                    content: "Ingresar el ancho de banda de carga máximo proporcionado por su ISP (Internet Service Provider - Proveedor de Servicios de Internet)."
                }, {
                    type: "name",
                    title: "Ancho de Banda de Descarga",
                    content: "Ingresar el ancho de banda de descarga máximo proporcionado por su ISP."
                }, {
                    type: "name",
                    title: "Garantía de Prioridad Alta ",
                    content: "Especificar un porcentaje para el tráfico de prioridad alta."
                }, {
                    type: "name",
                    title: "Garantía de Prioridad Media",
                    content: "Especificar un porcentaje para el tráfico de prioridad media."
                }, {
                    type: "name",
                    title: "Garantía de Prioridad Baja",
                    content: "Especificar un porcentaje para el tráfico de prioridad baja."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "La cantidad máxima (porcentaje) de todas las prioridades debe ser 1."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar todas sus configuraciones."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Lista de Reglas de QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo",
                    content: "Seleccionar un tipo para agregar la lista de reglas de QoS."
                }, {
                    type: "step",
                    title: "Para configurar una regla para la prioridad alta / media / baja Por Dispositivo",
                    content: ["1. Dar clic en Agregar.", "2. Seleccionar Por Dispositivo.", "3. Dar clic en Ver Dispositivos Existentes para seleccionar su dispositivo deseado de la Lista de Dispositivos de Acceso; o puede ingresar el Nombre del Dispositivo y su Dirección MAC de manera manual en los campos de Nombre del Dispositivo y Dirección MAC.", "4. Dar clic en OK."]
                }, {
                    type: "step",
                    title: "Para configurar una regla para la prioridad alta / media / baja Por Aplicación",
                    content: ["1. Dar clic en Agregar.", "2. Seleccionar Por Aplicación.", "3. Seleccionar su aplicación deseada de la lista de Aplicación, o puede personalizar una aplicación configurando el nombre, protocolo, y puerto en los campos correspondientes.", "4. Dar clic en OK."]
                }, {
                    type: "step",
                    title: "Para configurar una regla para la prioridad alta / media / baja Por Puerto Físico",
                    content: ["1. Dar clic en Agregar.", "2. Seleccionar Por Puerto Físico.", "3. Seleccionar su puerto deseado.", "4. Dar clic en OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Actualización de la Base de Datos",
            CONTENT: [
                {
                    type: "name",
                    title: "Archivo Nuevo de la Base de Datos",
                    content: "Dar clic en Explorar para localizar su archivo nuevo de la base de datos. Seleccionarlo y dar clic en Actualizar para actualizar su base de datos a una versión más nueva."
                }, {
                    type: "name",
                    title: "Versión de la Base de Datos",
                    content: "Muestra la versión de la base de datos actual."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Cortafuegos",
            CONTENT: [
                {
                    type: "name",
                    title: "Cortafuegos de SPI",
                    content: "El cortafuegos de SPI (Stateful Packet Inspection - Inspección Superficial de Paquetes) previene ciber-ataques y valida el tráfico que está pasando a través del router basado en el protocolo. El cortafuegos de SPI está habilitado de manera predeterminada."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Protección de DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Protección de DoS",
                    content: "La Protección de DoS (Denial of Service - Negación del Servicio) protege su LAN contra ataques de DoS que saturan su red con solicitudes del servidor. De manera predeterminada, la Protección de DoS está deshabilitada (Apagada)."
                }, {
                    type: "name",
                    title: "Filtrado de Ataques de ICMP-FLOOD",
                    content: "Habilitar para prevenir el ataque masivo de ICMP (Internet Control Message Protocol - Protocolo de Mensajes de Control de Internet)."
                }, {
                    type: "name",
                    title: "Filtrado de Ataques de UDP-FLOOD",
                    content: "Habilitar para prevenir el ataque masivo de UDP (User Datagram Protocol - Protocolo de Datagramas de Usuario)"
                }, {
                    type: "name",
                    title: "Filtrado de Ataques de TCP-SYN-FLOOD",
                    content: "Habilitar para prevenir el ataque masivo de TCP-SYN (Transmission Control Protocol-Synchronize - Protocolo de Control de Transmisión - Sincronizar).",
                    children: [
                        {
                            type: "name",
                            title: "Apagado",
                            content: "Sin protección."
                        }, {
                            type: "name",
                            title: "Bajo",
                            content: "Nivel bajo de protección y bajo impacto en el desempeño del router."
                        }, {
                            type: "name",
                            title: "Medio",
                            content: "Nivel moderado de protección e impacto semi-notable en el desempeño del router."
                        }, {
                            type: "name",
                            title: "Alto",
                            content: "Nivel alto de protección pero un impacto notable en el desempeño del router."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignorar el Paquete Ping Desde el Puerto de WAN",
                    content: "Habilitar para ignorar paquetes ping desde el puerto WAN."
                }, {
                    type: "name",
                    title: "Prohibir el Paquete Ping desde el puerto LAN",
                    content: "Habilitar para prohibir los paquetes ping desde el puerto LAN."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtro de MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Filtro MAC se usa para permitir o bloquear computadoras y otros dispositivos específicos el acceso a su red. Cuando un dispositivo es bloqueado, es incapaz de conectarse al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Configuraciones del Filtro de MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro de MAC",
                            content: "<b>Activar</b> para habilitar esta característica. Si la característica está desactivada (Apagado), todos los dispositivos tienen permitido conectarse. "
                        }
                    ]
                }, {
                    type: "name",
                    title: "Seleccionar la regla de filtrado",
                    content: "Seleccionar para bloquear o permitir que los dispositivos cliente listados en la Lista de Dispositivos tengan acceso a la red inalámbrica. Dar clic en <b>Guardar</b> para guardar sus configuraciones."
                }, {
                    type: "name",
                    title: "Lista de Dispositivos",
                    children: [
                        {
                            type: "step",
                            title: "Para agregar un dispositivo cliente"
                        }, {
                            type: "step",
                            title: "Para modificar o borrar un dispositivo cliente",
                            content: "Dar clic en el icono de <b>Editar</b> o en el icono de <b>Papelera de Reciclaje</b> que corresponda al dispositivo que desea modificar o borrar."
                        }, {
                            type: "step",
                            title: "Para borrar múltiples dispositivos en la Lista de Dispositivos",
                            content: "Seleccionar la casilla de verificación correspondiente de los dispositivos que tiene que borrar, y dar clic en <b>Borrar</b> arriba de la tabla."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtro de MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Filtro MAC se usa para permitir o bloquear computadoras y otros dispositivos específicos el acceso a su red. Cuando un dispositivo es bloqueado, es incapaz de conectarse al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Configuraciones del Filtro de MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro de MAC",
                            content: "<b>Activar</b> para habilitar esta característica. Si la característica está desactivada (Apagado), todos los dispositivos tienen permitido conectarse. "
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Seleccionar la regla de filtrado",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccionar para bloquear o permitir que los dispositivos cliente listados en la Lista de Dispositivos tengan acceso a la red inalámbrica. Dar clic en <b>Guardar</b> para guardar sus configuraciones."
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar sus configuraciones ."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Lista de Dispositivos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para agregar un dispositivo cliente",
                    content: ["1. Dar clic en <b>Agregar</b>.", "2. Dar clic en <b>Ver Dispositivos</b> y seleccionar la dirección MAC del dispositivo de la lista o ingresar la dirección MAC manualmente.", "3. Ingresar una breve descripción para el dispositivo.", "4. Seleccionar <b>Habilitar esta entrada.</b>", "5. Dar clic en <b>OK</b>"]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo en la Lista de Dispositivos",
                    content: "Dar clic en el icono de <b>Editar</b> o en el icono de <b>Papelera de Reciclaje</b> que corresponda al dispositivo que desea modificar o borrar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos en la Lista de Dispositivos",
                    content: "Seleccionar la casilla de verificación correspondiente de los dispositivos que desea borrar, y dar clic en <b>Borrar</b> arriba de la tabla."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Sincronizar Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con la característica Sincronizar Wi-Fi habilitada, cualquier cambio realizado a las configuraciones del Wi-Fi de un extensor powerline, se sincronizará automáticamente a los otros extensores powerline en la misma red powerline cuya característica del Sincronizar Wi-Fi también está habilitada. Tenga en cuenta que si el nombre predeterminado de fábrica, es decir, HomePlugAV, está siendo utilizado, la función Move Wi-Fi se desactivará automáticamente."
                }, {
                    type: "name",
                    title: "Sincronizar Wi-Fi",
                    content: "<b>Activar</b> para habilitar esta característica."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Lista del Host de DoS Bloqueado",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista del Host de DoS Bloqueada",
                    content: "Lista la Dirección IP y la Dirección MAC desde cualquier fuente de ataque de DoS bloqueada."
                }, {
                    type: "step",
                    title: "Para borrar una entrada",
                    content: "En la Lista del Host, seleccionar la entrada que desea borrar y dar clic en Borrar arriba de la tabla."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Control de Acceso",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Control de Acceso se usa para permitir o bloquear el acceso a su red de computadoras específicas y otros dispositivos. Cuando un dispositivo es bloqueado, es capaz de obtener una dirección IP del router, pero no puede comunicarse con otros dispositivos o conectarse a Internet"
                }, {
                    type: "paragraph",
                    content: "Para utilizar el control de acceso, habilitar esta función y especificar una lista blanca o negra. Si el Control de Acceso está desactivado (Apagado), todos los dispositivos, incluyendo la lista negra, están autorizados a conectarse."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Modo de Acceso",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Sólo los dispositivos de la Lista Negra tendrán negado el acceso a la red. "
                }, {
                    type: "name",
                    title: "Lista Blanca",
                    content: "Sólo los dispositivos de la Lista Blanca tendrán permitido el acceso a la red."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Dispositivo en Línea",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre del Dispositivo",
                    content: "Muestra el nombre del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la Dirección MAC del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "Muestra el tipo de conexión del dispositivo conectado."
                }, {
                    type: "step",
                    title: "Para bloquear un dispositivo",
                    content: "En la tabla de Dispositivos en Línea, dar clic en el ícono de Bloquear en la columna de Modificar que corresponda al dispositivo que desee bloquear. "
                }, {
                    type: "step",
                    title: "Para bloquear múltiples dispositivos",
                    content: "En la tabla de Dispositivos en línea, seleccionar todos los dispositivos que desea bloquear, dar clic en Bloquear arriba de la tabla. El dispositivo será agregado automáticamente a los Dispositivos en la Lista Negra o Lista Blanca."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Dispositivos incluidos en la Lista Negra / Lista Blanca",
            CONTENT: [
                {
                    type: "step",
                    title: "Para poner un dispositivo en la lista negra o en la lista blanca",
                    content: ["1. Dar clic en el ícono de Agregar.", "2. Ingresar el Nombre del Dispositivo.", "3. Ingresar la dirección MAC del dispositivo.", "4. Dar clic en OK."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo en la Lista Negra / Lista Blanca",
                    content: "En la tabla de la Lista Negra / Lista Blanca, dar clic en el icono de Modificar o el icono de Borrar que corresponda al dispositivo que desea modificar o borrar. "
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos en la Lista Negra / Lista Blanca",
                    content: "En la tabla de la Lista Negra / Lista Blanca, seleccionar todos los dispositivos que desea borrar."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Configuraciones",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Enlace de ARP (Address Resolution Protocol - Protocolo de Resolución de Direcciones) es útil para controlar el acceso de una computadora específica en la LAN mediante el enlace de la dirección IP y la dirección MAC del dispositivo en conjunto. El enlace de ARP también evita que otros dispositivos usen una dirección IP específica."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Lista de ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra las direcciones MAC e IP de los dispositivos conectados actualmente."
                }, {
                    type: "name",
                    title: "Número de Entrada de ARP",
                    content: "Muestra el número total de dispositivos que están conectados actualmente al router."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP asignada al dispositivo conectado."
                }, {
                    type: "name",
                    title: "Enlazado",
                    content: "Indica si las direcciones MAC e IP están enlazadas o no."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Vincular o Borrar la entrada correspondiente de la lista."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "No puede enlazar la misma dirección IP a más de una dirección MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Lista de Enlace",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar un dispositivo con el enlace de ARP",
                    content: [
                        "1. Dar clic en Agregar.",
                        "2. Ingresar la Dirección MAC del dispositivo.",
                        "3. Ingresar una Dirección IP que desee enlazar a la dirección MAC de arriba.",
                        "4. Ingresar una Descripción para este dispositivo. (Opcional)",
                        "5. Seleccionar Habilitar.",
                        "6. Dar clic en OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una entrada",
                    content: "En la Lista de Enlace, dar clic en el ícono de Modificar o en el ícono de Borrar que corresponda a la entrada que desee modificar o borrar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples entradas",
                    content: "En la Lista de Enlace, seleccionar todas las entradas que desea borrar, dar clic en Borrar arriba de la tabla."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Seleccionar para habilitar (Encendido) o deshabilitar (Apagado) la característica de IPv6 del router."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Estático"
                }, {
                    type: "name",
                    title: "IP Estático",
                    content: "Seleccionar este tipo si su ISP usa la asignación de direcciones IPv6 Estático."
                }, {
                    type: "name",
                    title: "Dirección IPv6/ Puerta de Enlace Predeterminada/ DNS Primario / DNS Secundario",
                    content: "Ingresar estos parámetros según sean proporcionados por el ISP."
                }, {
                    type: "name",
                    title: "Tamaño de MTU",
                    content: "El tamaño del MTU (Maximum Transmission Unit - Unidad de Transmisión Máxima) típico y predeterminado para la mayoría de las redes Ethernet es 1500 Bytes. No se recomienda cambiar el tamaño del MTU predeterminado a menos que se requiera por el ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Dinámico"
                }, {
                    type: "name",
                    title: "IP Dinámico",
                    content: "Seleccionar este tipo si su ISP usa la asignación de direcciones IPv6 Dinámico"
                }, {
                    type: "name",
                    title: "Dirección IPv6 / DNS Primario / DNS Secundario",
                    content: "Estos parámetros son asignados automáticamente por el servidor DHCPv6 de su ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Dar clic en este botón para obtener parámetros nuevos de IPv6 del servidor DHCPv6 del ISP."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Dar clic en este botón para liberar todas las direcciones IPv6 asignadas por servidor DHCPv6 del ISP."
                }, {
                    type: "name",
                    title: "Obtener la Dirección IPv6",
                    content: " Seleccionar para \"Obtener Dirección IPv6 no temporal\" u \"Obtener delegación del prefijo IPv6\" de acuerdo a su ISP."
                }, {
                    type: "name",
                    title: "Dirección DNS",
                    content: "Seleccionar para \"Obtener de manera dinámica del ISP\" o \" \"Usar la siguiente Dirección DNS\". Si se selecciona \"Usar la siguiente Dirección DNS\", por favor ingrese de manera manual la dirección DNS proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "DNS Primario / DNS Secundario",
                    content: ""
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Seleccionar este tipo si su ISP usa PPPoEv6, y le proporciona un nombre de usuario y contraseña."
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar estos parámetros según se proporcionen por su ISP."
                }, {
                    type: "name",
                    title: "Dirección IPv6",
                    content: "Esta dirección será asignada de manera automática por medio del servidor DHCPv6 del ISP, después de ingresar el nombre de usuario y contraseña y dar clic en Conectar."
                }, {
                    type: "name",
                    title: "Dirección DNS",
                    content: "Seleccionar para \"Obtener de manera dinámica del ISP\" o \" \"Usar la siguiente Dirección DNS\". Si se selecciona \"Usar la siguiente Dirección DNS\", por favor ingrese de manera manual la dirección DNS proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "Obtener Dirección IPv6",
                    content: "Seleccionar \"No temporal\" o \"Delegación del prefijo\" o \"Especificado por el ISP\" de acuerdo a su ISP. Si selecciona \"Especificado por el ISP\", necesita ingresar de manera manual la dirección IPv6 como la proporcionó su ISP. Si seleciona \"No-temporal\" o \"Delación del prefijo\", la dirección IPv6 será asignada automáticamente por el servidor DHCPv6 del ISP.",
                    children: [
                        {
                            type: "name",
                            title: "No temporal",
                            content: "Obtener una dirección IPv6  no temporal por el Servidor DHCPv6 del ISP (Internet Service Provider - Proveedor de Servicios de Internet)"
                        }, {
                            type: "name",
                            title: "Delegación del Prefijo",
                            content: "Obtener una dirección IPv6  de delegación del prefijo por el Servidor DHCPv6 del ISP (Internet Service Provider - Proveedor de Servicios de Internet) y el cliente en la LAN crea una dirección  IPv6 con la delegación."
                        }, {
                            type: "name",
                            title: "Especificado por el ISP",
                            content: "Usar la dirección IPv6 estática especificada por el ISP."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Dar clic en este botón para conectarse a Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Dar clic en este botón para desconectarse de Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: Túnel 6to4"
                }, {
                    type: "name",
                    title: "Túnel 6to4",
                    content: "Seleccionar este tipo si su ISP usa el despliegue de 6to4 para asignar la dirección."
                }, {
                    type: "name",
                    title: "Dirección IPv4 / Máscara de Subred de IPv4 / Puerta de Enlace Predeterminada de IPv4 / Dirección de Túnel",
                    content: "Estos parámetros se generarán de manera dinámica por medio de los parámetros de IPv4 del puerto WAN después de dar clic en Conectar."
                }, {
                    type: "name",
                    title: "Usar el siguiente Servidor DNS",
                    content: "Seleccionar esta casilla de verificación para habilitar esta opción. Y después ingresar el DNS primario / DNS secundario como lo proporcionó su ISP."
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Dar clic en este botón para conectarse a Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Dar clic en este botón para desconectarse de Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Seleccionar este tipo si su ISP usa el despliegue de 6RD y proporciona una Dirección IPv4 y  el prefijo de la dirección IPv6."
                }, {
                    type: "name",
                    title: "Tipo de Configuración",
                    content: "Seleccionar Auto o Manual para configurar los parámetros del canal 6RD de acuerdo a su ISP. Si los parámetros predeterminados de abajo coinciden con aquellos proporcionados por su ISP, puede seleccionar Auto; de otro modo, seleccione Manual e ingrese los parámetros como los proporcionó por su ISP."
                }, {
                    type: "name",
                    title: "Longitud de la Máscara de IPv4 / Prefijo de 6RD / Longitud del Prefijo de 6RD / Dirección IPv4 de Relé de Borde",
                    content: "Revise si estos parámetros preestablecidos coinciden con aquellos proporcionados por su ISP. Puede mantener los valores predeterminados o ingresarlos de manera manual como los proporcionó su ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Seleccionar este tipo si su ISP usa el despliegue de DS-Lite y le proporciona un nombre de dominio de AFTR o dirección IPv6 para configurar un túnel IPv4-en-IPv6 en la red de IPv6 para comunicar el tráfico de IPv4 o el tráfico de IPv6 en su propia red respectiva."
                }, {
                    type: "name",
                    title: "Nombre de AFTR",
                    content: "AFTR es la abreviatura de Address Family Transition Router (Router de Transición de Dirección Familiar). En este campo, ingrese el nombre de dominio de AFTR o la dirección IPv6 como lo proporcionó su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria",
                    content: "Seleccionar el tipo de conexión secundaria según como lo proporcionó su ISP.",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinámico",
                            content: "Seleccionar si su ISP le proporciona el IP Dinámico como el tipo de conexión secundaria y los parámetros de Dirección IPv6, DNS Primario / DNS Secundario serán asignados automáticamente por el servidor DHCPv6 del ISP."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Seleccionar este tipo si su ISP usa la asignación de direcciones IPv6 Estáticas."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Seleccionar si su ISP proporciona PPPoE como el tipo de conexión secundaria e ingrese el nombre de usuario / contraseña como lo proporcionó su ISP. La dirección IPv6 será asignada automáticamente después de dar clic en Conectar."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: Transferencia (Puente)"
                }, {
                    type: "paragraph",
                    content: "Seleccionar este tipo si su ISP usa el despliegue de la red Transferencia (Puente). No se requiere ninguna configuración para este tipo de conexión."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Excepto para la Transferencia (Puente), los otros 6 tipos de conexión de Internet requieren configuraciones para los parámetros de la LAN de IPv4 al mismo tiempo."
                }, {
                    type: "name",
                    title: "Tipo Asignado",
                    content: "Seleccionar el adecuado de acuerdo a su ISP.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Para asignar automáticamente las direcciones IP a los clientes en la LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de la Dirección",
                                    content: "Ingresar el prefijo de la dirección según se proporcione por su ISP."
                                }, {
                                    type: "name",
                                    title: "Tiempo de Desconexión",
                                    content: "Significa el tiempo cuando la dirección IP asignada permanece válida. Mantenga el valor predeterminado de 86400 segundos o cámbielo si se requiere por su ISP."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 del ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+Stateless DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de la Dirección",
                                    content: "Ingresar el prefijo de la dirección según se proporcione por su ISP."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 del ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de la Dirección",
                                    content: "Ingresar el prefijo de la dirección según se proporcione por su ISP."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 del ISP."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "Clon de MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Usar la Dirección MAC Predeterminada",
                    content: "NO cambiar la dirección MAC predeterminada del router, en caso que el ISP no enlace la dirección IP asignada a la dirección MAC."
                }, {
                    type: "name",
                    title: "Usar la Dirección MAC Actual de la Computadora",
                    content: "Seleccionar para copiar la dirección MAC de la computadora que está conectada al router, en caso que el ISP enlace la dirección IP asignada a la dirección MAC de la computadora."
                }, {
                    type: "name",
                    title: "Usar la Dirección MAC Personalizada",
                    content: "Ingresar la Dirección MAC manualmente, en caso que el ISP enlace la dirección IP asignada a la dirección MAC específica."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Configuraciones de la Hora",
            CONTENT: [
                {
                    type: "step",
                    title: "Para sincronizar automáticamente la hora",
                    content: ["1. Seleccionar su <b>Zona Horaria</b> local del menú desplegable.", "2. En el campo de <b>Servidor I de NTP </b>, ingresar la dirección IP de su Servidor NTP deseado. (Opcional)", "3. En el campo de <b>Servidor II de NTP </b>, ingresar la dirección IP del segundo Servidor NTP. (Opcional)", "4. Dar clic en </b>Obtener GTM</b>."]
                }, {
                    type: "step",
                    title: "",
                    content: ["1. En el campo de <b>Configuraciones de la Hora </b>, seleccionar su <b>Zona Horaria</b> local.", "2. Ingresar la <b>Fecha </b> actual.", "3. Seleccionar la <b>Hora</b> actual (en formato de reloj de 24 horas, ejemplo, 16:00:00 es 04:00PM).", "4. Dar clic en <b>Guardar</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Horario de Verano",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar el Horario de Verano",
                    content: ["1. Seleccionar <b>Habilitar Horario de Verano</b>.", "2. Seleccionar la fecha de <b>Inicio</b> correcta y la hora cuando el horario de verano comience en su zona horaria local.", "3. Seleccionar la fecha <b>Final</b> correcta y la hora cuando el horario de verano finalice en su zona horaria local.", "4. Dar clic en <b>Guardar</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnóstico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El router proporciona las herramientas de Ping y Traceroute para ayudarle a solucionar problemas de conectividad de la red. La herramienta Ping envía paquetes a una Dirección IP o Nombre de Dominio objetivo y registra los resultados, como el número de paquetes enviados / recibidos, y el tiempo de propagación en ambos sentidos. La herramienta de Traceroute envía paquetes a una Dirección IP  o Nombre de Dominio objetivo y muestra el número de saltos y el tiempo para llegar al destino."
                }, {
                    type: "paragraph",
                    content: "Puede verificar el ping y traceroute en un dispositivo local por medio de una dirección IP o un nombre de dominio, como google.com, yahoo.com, etc."
                }, {
                    type: "step",
                    title: "Para diagnosticar usando Ping",
                    content: ["1. Ingresar la Dirección IP o Nombre de Dominio Objetivo.", "2. Dar clic en el Ícono de Flecha para abrir el menú de Avanzado y especificar el Conteo de Ping, y el Tamaño del Paquete de Ping. (Opcional)", "3. Dar clic en Iniciar."]
                }, {
                    type: "step",
                    title: "Para diagnosticar usando Traceroute",
                    content: ["1. Ingresar la Dirección IP o Nombre de Dominio objetivo.", "2. Dar clic en el Ícono de Flecha para abrir el menú de Avanzado y especificar el número de saltos (a ser alcanzados) en el campo de TTL (Time to Live - Tiempo de Vida) Máximo de Traceroute. El valor predeterminado es 20. (Opcional)", "3. Dar clic en Iniciar."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Actualización del Firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Antes de actualizar el firmware del extensor powerline, necesitará descargar la actualización del firmware más reciente del sitio de Internet <a class=\"link\" href=\"http://www.tp-link.com/es/support/\" target=\"_blank\">Soporte de TP-LINK</a> a su computadora."
                }, {
                    type: "step",
                    title: "IMPORTANTE: Para prevenir fallas de actualización, por favor tome en cuenta lo siguiente: ",
                    content: ["Asegúrese que el archivo del firmware más reciente coincida con la versión hardware (como se muestra en la página de Actualización del Firmware).", "Asegúrese de tener una conexión estable entre el extensor powerline y su computadora. NO se recomienda actualizar el firmware inalámbricamente.", "Realice una copia de seguridad (respaldo) de la configuración de su extensor powerline.", "NO apague el extensor powerline durante la actualización del firmware."]
                }, {
                    type: "step",
                    title: "Para actualizar el firmware del extensor powerline",
                    content: ["1. Dar clic en <b>Examinar</b>.", "2. Localizar y seleccionar el archivo del firmware descargado.", "3. Dar clic en <b>Actualizar</b>."]
                }, {
                    type: "paragraph",
                    content: "El proceso de actualización toma unos minutos en completarse. Por favor NO apague el extensor powerline mientras la actualización está en progreso."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Para actualizar el firmware en línea",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Haga clic en Actualizar y haga clic en Sí cuando se le solicite, a continuación el extensor descargará automáticamente el último archivo de firmware y actualización. También puede hacer clic en Comprobar actualización para verificar la última versión."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Para actualizar el firmware manualmente",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Dar clic en Soporte en la parte inferior de la página y descargar el firmware más reciente para el equipo. Por favor, asegúrese de que el archivo de firmware que desea descargar coincide con la versión de hardware del router como se muestra en la página.", " 2. Dar clic en Examinar y seleccionar el archivo de firmware descargado. ", "3. Dar clic en Actualizar."]
                }, {
                    type: "paragraph",
                    content: ["La actualización del firmware tarda unos minutos en completarse. El extensor se reiniciará automáticamente cuando finalice la actualización del firmware."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Copia de Seguridad",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Se recomienda ampliamente que haga una copia de seguridad de sus configuraciones actuales en caso de que sea necesaria una recuperación para restaurar el sistema a un estado anterior o a los ajustes predeterminados de fábrica. "
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Crear copia de seguridad</b> para guardar sus configuraciones actuales a su computadora. Asegúrese de guardar el archivo de la copia de seguridad en una ubicación segura de tal manera que pueda recuperar y restaurar el router posteriormente, si es necesario. "
                }
            ]
        },
        RESTORE: {
            TITLE: "Restaurar",
            CONTENT: [
                {
                    type: "step",
                    title: "Para restaurar desde una copia de seguridad",
                    content: ["1. Dar clic en <b>Examinar</b>.", "2. Localizar y seleccionar el archivo de la copia de seguridad.", "3. Dar clic en <b>Restaurar</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Restauración a los Ajustes de Fábrica ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dar clic en <b>Restauración a los Ajustes de Fábrica</b> para restablecer su extensor powerline a sus configuraciones predeterminadas de fábrica."
                }, {
                    type: "note",
                    title: "Nota",
                    content: ["1. Restauración de Fabrica borrará todos los ajustes que haya configurado en el extensor powerline. Para volver a conectarse a la página de administración del extensor, utilice <b> admin </ b> para el nombre de usuario y la contraseña predeterminado.", "2. No apague el extensor durante el proceso de copia de seguridad o restauración."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Administración de Cuentas",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta página le permite cambiar su nombre de usuario y/o contraseña de inicio de sesión."
                }, {
                    type: "name",
                    title: "Nombre de Usuario Anterior",
                    content: "Escriba su nombre de usuario actual."
                }, {
                    type: "name",
                    title: "Contraseña Anterior",
                    content: "Escriba su contraseña actual."
                }, {
                    type: "name",
                    title: "Nombre de Usuario Nuevo",
                    content: "Escriba su nombre de usuario nuevo."
                }, {
                    type: "name",
                    title: "Contraseña Nueva",
                    content: "Escriba su contraseña nueva."
                }, {
                    type: "name",
                    title: "Confirmar Contraseña Nueva",
                    content: "Escriba su contraseña de nuevo."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si cambia el nombre de usuario y la contraseña actuales usados para iniciar sesión en el extensor powerline, asegúrese de anotar la nueva información de inicio de sesión en una ubicación segura. Una contraseña suficientemente segura debe tener 8 caracteres o más de longitud como mínimo, combinando letras mayúsculas y minúsculas, números y puntuaciones"
                }, {
                    type: "paragraph",
                    content: "Dar clic en <b>Guardar</b> para guardar todas sus configuraciones."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Recuperación de la Contraseña",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar la Recuperación de la Contraseña",
                    content: "Se recomienda ampliamente activar la función de Recuperación de Contraseña, la cual enviará su nombre de usuario y contraseña  olvidado o perdido a su correo electrónico."
                }, {
                    type: "name",
                    title: "De",
                    content: "Ingresar la dirección válida de correo electrónico a ser utilizada para el correo electrónico saliente"
                }, {
                    type: "name",
                    title: "Para",
                    content: "Ingresar la dirección válida de correo electrónico a ser utilizada para el correo electrónico entrante."
                }, {
                    type: "name",
                    title: "Servidor SMTP",
                    content: "Ingresar la dirección del servidor SMTP que el router usa para enviar la información de la cuenta a través del correo electrónico."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Seleccionar Habilitar Autenticación si el servidor del correo electrónico saliente requiere autenticación para enviar correo electrónico, y llenar el Nombre de Usuario y Contraseña en los campos correspondientes. Estos campos distinguen entre mayúsculas y minúsculas."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Administración Local",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta sección le permite limitar el número de dispositivos cliente en su LAN que pueden tener acceso al router usando la autenticación basada en la dirección MAC."
                }, {
                    type: "name",
                    title: "Acceso para Todos los Dispositivos LAN Conectados",
                    content: "Activar para habilitar la administración local para todos los dispositivos conectados a la LAN o Desactivar para habilitar la administración para un dispositivo específico."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del dispositivo de acceso limitado."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra la descripción del dispositivo de acceso limitado."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual del dispositivo de acceso limitado (habilitado o deshabilitado)."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar y Borrar el dispositivo correspondiente de la lista."
                }, {
                    type: "step",
                    title: "Para agregar un dispositivo cliente a la lista",
                    content: ["1. Dar clic en Agregar.", "2. Dar clic en Ver Dispositivos Existentes para seleccionar un dispositivo existente o ingresar la dirección MAC de un dispositivo en el campo de Dirección MAC.", "3. Ingresar una Descripción para el dispositivo. (Opcional)", "4. Seleccionar Habilitar", "5. Dar clic en OK."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo en la lista",
                    content: "Dar clic en el icono de Modificar o en el icono de Borrar que corresponda al dispositivo que desea modificar o borrar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos",
                    content: "Seleccionar todos los dispositivos que desee borrar, dar clic en Borrar."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Administración Remota",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La característica de Administración Remota le permite acceder y configurar el router de manera remota desde Internet."
                }, {
                    type: "name",
                    title: "Deshabilitar la Administración Remota ",
                    content: "Seleccionar esta opción para habilitar la administración remota."
                }, {
                    type: "name",
                    title: "Habilitar la Administración Remota para Todos los Dispositivos",
                    content: "Seleccionar esta opción para habilitar la administración remota para todas las direcciones IP. Si se selecciona, ingresar el campo del Puerto de Administración a Través de Internet. "
                }, {
                    type: "name",
                    title: "Habilitar la Administración Remota para los Dispositivos Especificados",
                    content: "Seleccionar esta opción para habilitar la administración remota para una dirección IP específica. Si se selecciona, ingresar los campos del Puerto de Administración a Través de Internet y de la Dirección IP de la Administración Remota."
                }, {
                    type: "name",
                    title: "Puerto de Administración a Través de Internet",
                    content: "Ingresar el número de puerto a ser usado, entre 1024 y 65535,  el cual se usa para acceder a la interfaz de administración a través de Internet del router con mayor seguridad. Normalmente, los navegadores de Internet usan puerto 80 de servicio HTTP estándar. El puerto de servicio común y predeterminado es 8080, el cual es un puerto de servicio alternativo del HTTP."
                }, {
                    type: "name",
                    title: "Dirección IP de la Administración Remota",
                    content: "Ingresar una dirección IP válida o rango de IP para permitir el acceso al router. Si se ingresa 255.255.255.255, todos tienen permitido el acceso."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Registro del Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página de Registro del Sistema muestra una lista de las actividades (eventos) más recientes del extensor. Puede definir qué tipos de registros y/o el nivel de registros que desea ver."
                }, {
                    type: "name",
                    title: "Tipo",
                    content: "Seleccionar el tipo de registro del sistema a mostrar."
                }, {
                    type: "name",
                    title: "Nivel",
                    content: "Seleccionar el nivel del registro del sistema a mostrar. "
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Dar clic en este icono para actualizar el registro del sistema."
                }, {
                    type: "name",
                    title: "Borrar Todo",
                    content: "Dar clic en este icono para borrar todos los registros del sistema. "
                }, {
                    type: "name",
                    title: "Guardar Registro",
                    content: "Dar clic en este botón para descargar todos los registros del sistema a su computadora local. "
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Estadísticas de Tráfico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página de Estadísticas de Tráfico muestra el tráfico de la red de los paquetes enviados y recibidos de la LAN, WAN, y WLAN."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si se habilita NAT Boost,  Estadísticas de Tráfico debe estar deshabilitado."
                }, {
                    type: "name",
                    title: "Estadísticas de Tráfico",
                    content: "De manera predeterminada, Estadísticas de Tráfico está Desactivado. Para mostrar la información de las estadísticas, dar clic en Activar"
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Lista de Estadísticas de Tráfico",
            CONTENT: [
                {
                    type: "name",
                    title: "Dirección IP/Dirección MAC",
                    content: "Muestra la dirección IP y la dirección MAC del dispositivo cliente asociado."
                }, {
                    type: "name",
                    title: "Paquetes Totales",
                    content: "Muestra el número total de paquetes recibidos y transmitidos por el dispositivo del cliente desde el comienzo de la sesión o de la última reinicialización del contador."
                }, {
                    type: "name",
                    title: "Bytes Totales ",
                    content: "Muestra el número total de bytes recibidos y transmitidos por el dispositivo del cliente desde el comienzo de la sesión o de la última reinicialización del contador."
                }, {
                    type: "name",
                    title: "Paquetes Totales",
                    content: "Muestra el número actual de paquetes recibidos y transmitidos en un intervalo de tiempo específico. "
                }, {
                    type: "name",
                    title: "Bytes Actuales",
                    content: "Muestra el número actual de bytes recibidos y transmitidos en un intervalo de tiempo específico. "
                }, {
                    type: "name",
                    title: "ICMP Tx Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad máxima de transmisión de paquetes ICMP transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "UDP Tx Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad máxima de transmisión de paquetes UDP transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "SYN Tx Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad máxima de transmisión de paquetes TCP SYN transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Restablecer (a cero) y Borrar las estadísticas correspondientes de la lista."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Dar clic para actualizar la información de estadística en la página"
                }, {
                    type: "name",
                    title: "Restablecer Todo",
                    content: "Dar clic para restablecer todos los valores estadísticos en la lista a cero..  "
                }, {
                    type: "name",
                    title: "Borrar Todo",
                    content: "Dar clic para borrar toda la información estadística en la lista."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Inalámbrico de 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervalo de Baliza",
                    content: "Ingresar un valor entre 40 y 1000 en milisegundos para determinar la duración entre los paquetes de balizas que son transmitidos por el router para sincronizar la red inalámbrica. El valor predeterminado es 100 milisegundos."
                }, {
                    type: "name",
                    title: "Umbral de RTS",
                    content: "Ingresar un valor entre 1 y 2346 para determinar el tamaño del paquete de la transmisión de datos a través del router. De manera predeterminada, el tamaño del Umbral RTS (Request to Send - Petición de Envío) es 2346. Si el tamaño del paquete es mayor que el umbral preestablecido, el router envía tramas de Petición de Envío a una estación de recepción particular y negocia el envío de una trama de datos, o de otro modo el paquete será enviado inmediatamente."
                }, {
                    type: "name",
                    title: "Intervalo de DTIM",
                    content: "Este valor determina el intervalo de DTIM (Delivery Traffic Indication Message - Mensaje Indicativo de Tráfico de Entrega). Ingresar un valor entre 1 y 15 intervalos de baliza. El valor predeterminado es 1, indica que el intervalo de DTIM es el mismo que el Intervalo de Baliza."
                }, {
                    type: "name",
                    title: "Periodo de Actualización de Claves de Grupo",
                    content: "Ingresar el número de segundos (mínimo 30) para controlar el intervalo de tiempo para la renovación automática de la clave de encriptación. El valor predeterminado es 0, que indica ninguna renovación de la clave."
                }, {
                    type: "name",
                    title: "Característica de WMM",
                    content: "La función de WMM garantiza que los paquetes con mensajes de alta prioridad sean transmitidos preferencialmente. Está habilitado de manera predeterminada y se recomienda ampliamente."
                }, {
                    type: "name",
                    title: "Característica de GI Corto",
                    content: "Esta función está habilitada de manera predeterminada y se recomienda incrementar la capacidad de datos reduciendo el tiempo de GI (Guard Interval - Intervalo de Seguridad)."
                }, {
                    type: "name",
                    title: "Característica de Aislamiento de AP",
                    content: "De manera predeterminada, esta función está deshabilitada. Si desea limitar y restringir que todos los dispositivos inalámbricos conectados a su red interactúen entre sí, pero aún puedan acceder a Internet, seleccione la casilla de verificación de Habilitar Aislamiento de AP. "
                }, {
                    type: "name",
                    title: "Conexión en Puente de WDS",
                    content: "Habilitar la característica de Conexión en Puente de WDS (Wireless Distribution System - Sistema de Distribución Inalámbrico) para permitir que el router se una con otro punto de acceso (AP) en la red del área local inalámbrica (WLAN). Si se habilita esta característica, configurar lo siguiente: ",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Ingresar el SSID del WAP (Wireless Access Point - Punto de Acceso Inalámbrico) al que su router se conectará como cliente o use la característica de Examinar para encontrar todas las redes disponibles en el canal actual."
                        }, {
                            type: "name",
                            title: "Examinar",
                            content: "Dar clic en este botón para escanear y mostrar el SSID, BSSID, potencia de la señal, canal e información de seguridad de todas las redes inalámbricas disponibles dentro del rango. Una vez que seleccione una red, los campos de SSID, Dirección MAC, y Seguridad se llenarán automáticamente."
                        }, {
                            type: "name",
                            title: "Dirección MAC (a ser conectado en puente)",
                            content: "Ingresar la dirección MAC (BSSID) en formato de 12 caracteres hexadecimales (0-9, a-f, A-F) separado por guiones del punto de acceso inalámbrico al que el router se conectará como cliente. Si selecciona el AP deseado a través de la característica de Examinar, el campo de dirección MAC es alimentado automáticamente. "
                        }, {
                            type: "name",
                            title: "Seguridad",
                            content: "Seleccionar el tipo correcto de seguridad del punto de acceso seleccionado, No, WPA-PSK/WPA2-PSK o WEP. Si selecciona el AP deseado a través de la característica de Examinar, el campo de Seguridad es llenado automáticamente",
                            children: [
                                {
                                    type: "name",
                                    title: "Contraseña",
                                    content: "Esta opción está disponible cuando el tipo de seguridad es WPA-PSK/WPA2-PSK o WEP. Ingresar la contraseña de seguridad del punto de acceso seleccionado."
                                }, {
                                    type: "name",
                                    title: "Tipo de Autenticación",
                                    content: "Esta opción sólo está disponible cuando el tipo de seguridad es WEP (Wired Equivalent Privacy - Privacidad Equivalente al Cableado). Seleccionar el tipo de autenticación adecuado (Auto, Sistema Abierto o Clave Compartida) usado del punto de acceso seleccionado."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave de WEP",
                                    content: "Esta opción sólo está disponible cuando el tipo de seguridad es WEP. Seleccionar el formato clave (ASCII o Hexadecimal) usado del AP seleccionado."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar sus configuraciones"
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccionar Habilitar la casilla de verificación de WPS y dar clic en Guardar para habilitar la función de WPS (Wi-Fi Protected Setup) que le permite configurar fácilmente y conectar los dispositivos con WPS habilitado presionando el botón WPS."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccionar la casilla de verificación de Habilitar NAT y dar clic en Guardar para habilitar la función de NAT (Network Address Translation - Traducción de Direcciones de Red)."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Seleccionar la casilla de verificación de Habilitar NAT Boost y dar clic en Guardar para asegurar que su router tenga un mejor rendimiento."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "NAT Boost se deshabilitará cuando Estadísticas de Tráfico y QoS estén habilitados."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Configuraciones del Nivel de Protección DoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Nivel de Protección de DoS protege al router de ataques de TCP-SYN-Flood, UDP-Flood, e ICMP-Flood."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes de ICMP-FLOOD",
                    content: "Ingresar un valor de paquetes de ICMP entre 5 y 7200 para activar la protección de ICMP-FLOOD  inmediatamente cuando el número de paquetes excede el valor del umbral preestablecido."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes de UDP-FLOOD",
                    content: "Ingresar un valor de paquetes de UDP entre 5 y 7200  para activar la protección de UDP-FLOOD inmediatamente cuando el número de paquetes excede el valor del umbral preestablecido."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes de TCP-FLOOD",
                    content: "Ingresar un valor de paquetes de TCP-SYN entre 5 y 7200 paquetes  para activar la protección de TCP-SYN-FLOOD inmediatamente cuando el número de paquetes excede el valor del umbral preestablecido."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar sus configuraciones."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Dúplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Dúplex",
                    content: "Seleccionar el tipo dúplex de la lista desplegable."
                }, {
                    type: "paragraph",
                    content: "Dar clic en Guardar para guardar sus configuraciones"
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Estado de Internet",
                    content: "Muestra el estado actual de la conexión de Internet del router."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "Muestra el tipo de conexión de Internet."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP de Internet actual asignada al router."
                }, {
                    type: "name",
                    title: "Conexión Secundaria / Dirección IP",
                    content: "Muestra el tipo de la conexión secundaria y la dirección IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "Inalámbrico de 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Muestra el nombre de la red inalámbrica actual de la frecuencia de banda de 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Muestra el canal del cual transmite la red inalámbrica de 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Muestra la dirección MAC actual del inalámbrico de 2.4GHz/5GHz."
                }, {
                    type: "title",
                    title: "Red Inalámbrica de 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra si la Red para Invitados inalámbrica de 2.4GHz/5GHz está encendida (habilitada) o apagada (deshabilitada)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Muestra el nombre de la red inalámbrica de la Red para Invitados."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Clientes Inalámbricos / Conectados por Cable",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre",
                    content: "Muestra el nombre del cliente conectado al router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP asignada del cliente."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del cliente."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Impresora",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre",
                    content: "Muestra el nombre de la impresora conectada al router por medio del puerto USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "DISCO USB",
            CONTENT: [
                {
                    type: "name",
                    title: "Disco USB",
                    content: "Muestra la marca del disco USB conectado al router."
                }, {
                    type: "name",
                    title: "Total",
                    content: "Muestra el volumen total del disco USB."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "Muestra el espacio disponible del disco USB."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Detección Automática",
                    content: "Dar clic en este botón para hacer que el router detecte automáticamente su tipo de conexión de Internet actual."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si no está seguro qué tipo de conexión de Internet tiene, use la función de Detección Automática o contacte a su ISP para obtener asistencia."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Estático"
                }, {
                    type: "name",
                    title: "Dirección IP/ Máscara de Subred/ Puerta de Enlace Predeterminada/ DNS Primario/ DNS Secundario",
                    content: "Ingresar la información proporcionada por su ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Dinámico"
                }, {
                    type: "name",
                    title: "No Clonar la Dirección MAC/ Clonar la Dirección MAC Actual de la Computadora",
                    content: "Seleccionar si clona la dirección MAC o no, de acuerdo a su ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: PPPoE"
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Nombre de Usuario / Contraseña",
                    content: "Ingresar el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (IP Dinámico o IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinámico",
                            content: "Seleccionar si la Dirección IP y la Máscara de Subred son asignadas automáticamente por el ISP."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Seleccionar si la dirección IP, la Máscara de Subred, la Puerta de Enlace, y las direcciones DNS son proporcionadas por el ISP, e ingresar esta información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP del Servidor VPN / Nombre de Dominio",
                    content: "Ingresar la dirección IP del servidor VPN o nombre de dominio proporcionados por su ISP."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Configuraciones Inalámbricas",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Radio Inalámbrico",
                    content: "Seleccionar esta casilla de verificación para habilitar la frecuencia de radio inalámbrica de 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nombre de la Red (SSID)",
                    content: "Puede dejar el nombre predeterminado de la red inalámbrica (SSID) como está, o ingresar un nombre nuevo (hasta 32 caracteres). Este campo hace distinción entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccionar esta casilla de verificación si desea ocultar el nombre de la red (SSID) de 2.4GHz/5GHz de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Ingresar una contraseña de la red inalámbrica entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales en este campo (hace distinción entre mayúsculas y minúsculas)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Configuraciones del Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página de Configuraciones del Dispositivo muestra la información relacionada de cualquier dispositivo de almacenamiento USB conectado por medio del puerto USB."
                }, {
                    type: "name",
                    title: "Escanear",
                    content: "Generalmente el router detecta automáticamente cualquier dispositivo recién conectado. De lo contrario, dar clic en este botón para buscar cualquier dispositivo nuevo conectado y actualizar la página con la información actualizada. "
                }, {
                    type: "name",
                    title: "Volumen",
                    content: "Muestra el nombre del volumen USB."
                }, {
                    type: "name",
                    title: "Capacidad",
                    content: "Muestra la capacidad total de almacenamiento del USB."
                }, {
                    type: "name",
                    title: "Espacio Libre",
                    content: "Muestra el espacio de almacenamiento libre disponible actual."
                }, {
                    type: "name",
                    title: "Retirar de Forma Segura",
                    content: "Dar clic en este botón para retirar de manera segura el dispositivo de almacenamiento USB antes de desconectarlo físicamente del router.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Por favor tome en cuenta que el botón de Retirar de Manera Segura sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. También recuerde que no podrá retirar el dispositivo USB mientras el volumen actual está ocupado."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Activo",
                    content: "Esta casilla de verificación sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. Seleccionar para habilitar el uso compartido de archivos del dispositivo USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Configuraciones de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre del Servidor Multimedia / Red",
                    content: "Muestra el nombre usado para acceder al dispositivo de almacenamiento USB conectado."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Uso Compartido de Carpetas",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartir Todo",
                    content: "Activar para compartir todos los archivos y carpetas o Desactivar para sólo compartir las carpetas seleccionadas. "
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Se recomienda ampliamente habilitar la autenticación para requerir que los usuarios ingresen un nombre de usuario y contraseña válidos para tener acceso a todas las carpetas compartidas"
                }, {
                    type: "name",
                    title: "Nombre de la Carpeta",
                    content: "Muestra el nombre de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Ruta de la Carpeta",
                    content: "Muestra la ruta hacia la carpeta compartida."
                }, {
                    type: "name",
                    title: "Uso Compartido de Multimedia",
                    content: "Indica si la carpeta compartida permite el uso compartido de multimedia o no."
                }, {
                    type: "name",
                    title: "Nombre del Volumen",
                    content: "Muestra el nombre del volumen compartido."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado de la carpeta compartida mediante el indicador de foco. En verde (ENCENDIDO) está habilitado y en GRIS (APAGADO) está desactivado.  Puede activar o desactivar dando clic en el foco."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar la carpeta compartida correspondiente."
                }, {
                    type: "name",
                    title: "Agregar",
                    content: "Dar clic en este botón para crear una entrada nueva."
                }, {
                    type: "name",
                    title: "Borrar",
                    content: "Dar clic en este botón para borrar la entrada seleccionada  de la tabla."
                }, {
                    type: "name",
                    title: "Examinar",
                    content: "Dar clic en buscar una carpeta de uso compartido."
                }, {
                    type: "name",
                    title: "Permitir el Acceso a la Red para Invitados",
                    content: "Seleccionar para permitir que los clientes en la Red para Invitados tengan acceso a las carpetas de uso compartido."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Seleccionar para requerir que los usuarios tengan acceso a las carpetas de uso compartido con un nombre de usuario y contraseña válidos."
                }, {
                    type: "name",
                    title: "Habilitar el Acceso de Escritura",
                    content: "Seleccionar para permitir que los usuarios realicen cambios al contenido de la carpeta."
                }, {
                    type: "name",
                    title: "Habilitar el Uso Compartido de Multimedia",
                    content: "Seleccionar para habilitar el uso compartido de multimedia."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Servidor de Impresión",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar el Servidor de Impresión",
                    content: "Dar clic en ENCENDER para habilitar la función del servidor de impresión."
                }, {
                    type: "name",
                    title: "Nombre de la Impresora",
                    content: "Muestra el nombre de su impresora conectada al router."
                }, {
                    type: "step",
                    title: "Para configurar un Servidor de Impresión que puede ser usado en toda su red",
                    content: ["1. Conectar una impresora USB al puerto USB del router mediante un cable USB", "2. Instalar el controlador de la impresora en su computadora. Consultar los manuales del fabricante de la computadora para ver las instrucciones", "3. Instalar la Utilidad del Controlador de Impresoras USB de TP-LINK ya sea desde el CD de Recursos (Para Windows únicamente) o descargarlo (tanto para Windows como para Mac OS X) desde el sitio web oficial de TP-LINK."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Control Parental",
            CONTENT: [
                {
                    type: "name",
                    title: "Estado",
                    content: "Activar para habilitar la característica de Control Parental. De manera predeterminada, esta característica está deshabilitada."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Dispositivos Bajo Controles Parentales",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la lista de dispositivos bajo Control Parental."
                }, {
                    type: "name",
                    title: "Nombre del Dispositivo",
                    content: "Muestra el nombre de todos los dispositivos cliente conectados que están actualmente bajo el Control Parental."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC de todos los dispositivos cliente conectados que están actualmente bajo el Control Parental."
                }, {
                    type: "name",
                    title: "Tiempo de Acceso a Internet",
                    content: "Muestra los periodos de tiempo de acceso de restricción. "
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra una descripción breve del dispositivo conectado. Esta es una configuración opcional."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) del Control Parental del dispositivo correspondiente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Borrar el dispositivo correspondiente."
                }, {
                    type: "step",
                    title: "Para restringir un dispositivo cliente nuevo",
                    content: [
                        "1. Dar clic en Agregar.",
                        "2. Dar clic en Ver Dispositivos Existentes y seleccionar un dispositivo conectado actualmente desde la Lista de Dispositivos de Acceso; o ingresar el Nombre del Dispositivo y la Dirección MAC manualmente para agregar un dispositivo que no esté conectado.",
                        "3. Dar clic en el icono de Tiempo de Acceso a Internet para especificar un periodo de tiempo durante el cual aplique la restricción.",
                        "4. Ingresar una descripción breve en el campo de Descripción. (Opcional).",
                        "5. Seleccionar Habilitar.",
                        "6. Dar clic en OK para guardar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar o borrar una entrada de Control Parental, simplemente dar clic en el icono de Modificar para editar la información o en el ícono de Borrar para quitar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para borrar múltiples entradas, seleccionar todas las entradas y dar clic en Borrar arriba de la tabla."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Red para Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Red para Invitados le permite configurar una red inalámbrica separada con un nombre de red (SSID) y contraseña separados que sus invitados pueden usar para tener acceso a su red inalámbrica."
                }, {
                    type: "name",
                    title: "Permitir que los invitados se vean entre sí",
                    content: "Seleccionar esta casilla de verificación para permitir que los dispositivos inalámbricos en la Red para Invitados se vean entre sí."
                }, {
                    type: "name",
                    title: "Permitir que los invitados tengan acceso a mi red local",
                    content: "Seleccionar esta opción para evitar que los invitados inicien sesión en las interfaces de administración a través de Internet. "
                }, {
                    type: "name",
                    title: "Habilitar la Red para Invitados",
                    content: "Seleccionar esta casilla de verificación para habilitar la característica de Red para Invitados de 2,4 Ghz/5 GHz. "
                }, {
                    type: "name",
                    title: "Nombre de la Red Inalámbrica (SSID)",
                    content: "Usar la opción predeterminada de SSID de Invitado o crear un nombre nuevo (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccionar esta casilla de verificación si desea ocultar el SSID de Invitado de la lista de la red Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Crear una contraseña entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F) para proteger a la Red para Invitados."
                }
            ]
        },
        "": ""
    };
})(jQuery);
